/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.common.util;

import com.shimi.gsf.core.exception.BaseServiceException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

/*
 * Exception performing whole class analysis ignored.
 */
public class Exporter {
    public static final Logger log = LoggerFactory.getLogger(Exporter.class);

    public static byte[] exportExcel(String sheetName, List<String> headers, List<List<Object>> rows) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet(sheetName);
        Exporter.writeHeader(headers, (Workbook)workbook, (Sheet)sheet);
        Exporter.writeBody(rows, (Workbook)workbook, (Sheet)sheet);
        Exporter.autoSizeColumns((int)headers.size(), (Sheet)sheet);
        sheet.setAutoFilter(new CellRangeAddress(0, 0, 0, headers.size() - 1));
        sheet.createFreezePane(0, 1);
        return Exporter.writeWorkBook((Workbook)workbook).toByteArray();
    }

    private static void writeHeader(List<String> headers, Workbook workbook, Sheet sheet) {
        Font headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerFont.setFontHeightInPoints((short)12);
        CellStyle headerCellStyle = workbook.createCellStyle();
        headerCellStyle.setFont(headerFont);
        headerCellStyle.setAlignment(HorizontalAlignment.CENTER);
        headerCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.index);
        headerCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Row header = sheet.createRow(0);
        IntStream.range(0, headers.size()).forEach(index -> {
            Cell cell = header.createCell(index);
            cell.setCellValue((String)headers.get(index));
            cell.setCellStyle(headerCellStyle);
        });
    }

    protected static void writeBody(List<List<Object>> dataRows, Workbook workbook, Sheet sheet) {
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)12);
        CellStyle defaultCellStyle = workbook.createCellStyle();
        defaultCellStyle.setFont(font);
        defaultCellStyle.setWrapText(true);
        defaultCellStyle.setVerticalAlignment(VerticalAlignment.TOP);
        CellStyle dateCellStyle = workbook.createCellStyle();
        dateCellStyle.setFont(font);
        dateCellStyle.setVerticalAlignment(VerticalAlignment.TOP);
        dateCellStyle.setDataFormat(workbook.getCreationHelper().createDataFormat().getFormat("yyyy-mm-dd hh:mm:ss"));
        IntStream.range(0, dataRows.size()).forEach(rowIndex -> {
            List dataRow = (List)dataRows.get(rowIndex);
            Row row = sheet.createRow(rowIndex + 1);
            IntStream.range(0, dataRow.size()).forEach(columnIndex -> {
                Cell cell = row.createCell(columnIndex);
                Object cellValue = dataRow.get(columnIndex);
                if (cellValue != null) {
                    Object e = cellValue;
                    Objects.requireNonNull(e);
                    Object selector0$temp = e;
                    int index$1 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Date.class, Number.class, LocalDateTime.class, Boolean.class}, selector0$temp, index$1)) {
                        case 0: {
                            Date date = (Date)selector0$temp;
                            cell.setCellValue(date);
                            break;
                        }
                        case 1: {
                            Number number = (Number)selector0$temp;
                            cell.setCellValue(number.doubleValue());
                            break;
                        }
                        case 2: {
                            LocalDateTime localDateTime = (LocalDateTime)selector0$temp;
                            cell.setCellValue(localDateTime);
                            break;
                        }
                        case 3: {
                            Boolean b = (Boolean)selector0$temp;
                            cell.setCellValue(b.booleanValue());
                            break;
                        }
                        default: {
                            cell.setCellValue(cellValue.toString());
                        }
                    }
                }
                if (cellValue instanceof Date || cellValue instanceof LocalDateTime) {
                    cell.setCellStyle(dateCellStyle);
                } else {
                    cell.setCellStyle(defaultCellStyle);
                }
            });
        });
    }

    private static void autoSizeColumns(int columns, Sheet sheet) {
        IntStream.range(0, columns).forEach(columnIndex -> {
            sheet.autoSizeColumn(columnIndex);
            if (sheet.getColumnWidth(columnIndex) > 12800) {
                sheet.setColumnWidth(columnIndex, 12800);
            }
        });
    }

    private static ByteArrayOutputStream writeWorkBook(Workbook workbook) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)out);
            return out;
        }
        catch (IOException e) {
            throw new BaseServiceException("exportFailed", "Failed to export excel file", HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }
}

