/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.common.util;

import jakarta.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class IpUtil {
    private static final Logger log = LoggerFactory.getLogger(IpUtil.class);
    private static final String UNKNOWN = "unknown";
    private static final List<String> LOCAL_HOSTS = Arrays.asList("127.0.0.1", "0:0:0:0:0:0:0:1");
    private static final String SEPARATOR = ",";

    private IpUtil() {
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ipAddress;
        try {
            ipAddress = request.getHeader("x-forwarded-for");
            if (ipAddress == null || ipAddress.isEmpty() || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getHeader("Proxy-Client-IP");
            }
            if (ipAddress == null || ipAddress.isEmpty() || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getHeader("WL-Proxy-Client-IP");
            }
            if ((ipAddress == null || ipAddress.isEmpty() || "unknown".equalsIgnoreCase(ipAddress)) && LOCAL_HOSTS.contains(ipAddress = request.getRemoteAddr())) {
                ipAddress = IpUtil.getLocalHost((String)ipAddress);
            }
            if (ipAddress != null && ipAddress.length() > 15 && ipAddress.contains(",")) {
                ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
            }
        }
        catch (Exception e) {
            ipAddress = "";
        }
        return ipAddress;
    }

    private static String getLocalHost(String ipAddress) {
        InetAddress inet = null;
        try {
            inet = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            log.error("Error caught while getting local host address", (Throwable)e);
        }
        if (inet != null) {
            ipAddress = inet.getHostAddress();
        }
        return ipAddress;
    }
}

