/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.AttributeConverter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObjectToStringConverter<T>
implements AttributeConverter<T, String> {
    private final Logger log = LoggerFactory.getLogger(ObjectToStringConverter.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final TypeReference<T> typeReference;

    protected ObjectToStringConverter(TypeReference<T> typeReference) {
        this.typeReference = typeReference;
    }

    public String convertToDatabaseColumn(T data) {
        String value = "";
        try {
            value = this.mapper.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            this.log.error("Error caught: ", (Throwable)e);
        }
        return value;
    }

    public T convertToEntityAttribute(String data) {
        Object rootNode = null;
        if (data != null) {
            try {
                rootNode = this.mapper.readValue(data, this.typeReference);
            }
            catch (IOException e) {
                this.log.error("Error caught: ", (Throwable)e);
            }
        }
        return (T)rootNode;
    }
}

