/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.component.controller;

import com.shimi.gogoscrum.common.controller.BaseController;
import com.shimi.gogoscrum.component.dto.ComponentDto;
import com.shimi.gogoscrum.component.model.Component;
import com.shimi.gogoscrum.component.service.ComponentService;
import com.shimi.gsf.core.model.Entity;
import com.shimi.gsf.core.model.SnowflakeIdTraceableEntity;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/components"})
@CrossOrigin
@Tag(name="Component", description="Component management")
@RolesAllowed(value={"ROLE_USER"})
public class ComponentController
extends BaseController {
    @Autowired
    private ComponentService componentService;

    @Operation(summary="Create a new component")
    @PostMapping
    public ComponentDto create(@RequestBody ComponentDto componentDto) {
        Component savedComponent = (Component)this.componentService.create((Entity)componentDto.toEntity());
        return savedComponent.toDto();
    }

    @Operation(summary="Get component by ID")
    @Parameters(value={@Parameter(name="id", description="The component ID")})
    @GetMapping(value={"/{id}"})
    public ComponentDto get(@PathVariable long id) {
        Component component = (Component)this.componentService.get(Long.valueOf(id));
        return component.toDto();
    }

    @Operation(summary="Get the complete component tree")
    @Parameters(value={@Parameter(name="projectId", description="The ID of the project")})
    @GetMapping(value={"tree"})
    public ComponentDto getComponentTree(@RequestParam long projectId) {
        List components = this.componentService.findByProjectId(Long.valueOf(projectId));
        return this.assembleComponentTree(components);
    }

    @Operation(summary="Get all components as a list")
    @Parameters(value={@Parameter(name="projectId", description="The ID of the project")})
    @GetMapping
    public List<ComponentDto> getAllComponents(@RequestParam long projectId) {
        List components = this.componentService.findByProjectId(Long.valueOf(projectId));
        return components.stream().map(Component::toDto).collect(Collectors.toList());
    }

    private ComponentDto assembleComponentTree(List<Component> components) {
        ComponentDto root = new ComponentDto();
        root.setName("root");
        Map dtoMap = components.stream().collect(Collectors.toMap(SnowflakeIdTraceableEntity::getId, Component::toDto, (u, v) -> u, LinkedHashMap::new));
        dtoMap.values().forEach(dto -> {
            Long parentId = dto.getParentId();
            if (parentId != null && dtoMap.containsKey(parentId)) {
                ComponentDto parent = (ComponentDto)dtoMap.get(parentId);
                parent.getChildren().add(dto);
            } else {
                root.getChildren().add(dto);
            }
        });
        return root;
    }

    @Operation(summary="Update an existing component")
    @Parameters(value={@Parameter(name="id", description="The component ID")})
    @PutMapping(value={"/{id}"})
    public ComponentDto update(@PathVariable Long id, @RequestBody ComponentDto componentDto) {
        Component savedComponent = (Component)this.componentService.update(id, (Entity)componentDto.toEntity());
        return savedComponent.toDto();
    }

    @Operation(summary="Delete an existing component")
    @Parameters(value={@Parameter(name="id", description="The component ID")})
    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable Long id) {
        this.componentService.delete(id);
    }

    @Operation(summary="Update components seq")
    @PutMapping(value={"/seq"})
    public void updateSeq(@RequestBody List<Long> componentIds) {
        this.componentService.updateSeq(componentIds);
    }
}

