/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.component.model;

import com.shimi.gogoscrum.common.model.BaseEntity;
import com.shimi.gogoscrum.component.dto.ComponentDto;
import jakarta.persistence.Entity;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

@Entity
public class Component
extends BaseEntity {
    private static final long serialVersionUID = -111600323162979153L;
    private String name;
    private Long parentId;
    private String path;
    private Long projectId;
    private Integer seq = 0;

    public ComponentDto toDto() {
        ComponentDto dto = new ComponentDto();
        BeanUtils.copyProperties((Object)this, (Object)dto);
        if (this.createdBy != null) {
            dto.setCreatedBy(this.createdBy.toDto().normalize());
        }
        return dto;
    }

    public Component() {
    }

    public Component(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getPath() {
        return this.path;
    }

    public String getFullPath() {
        return (StringUtils.hasText((String)this.path) ? this.path : "/") + this.id + "/";
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Integer getSeq() {
        return this.seq;
    }

    public void setSeq(Integer seq) {
        this.seq = seq;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Component{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", parentId=").append(this.parentId);
        sb.append(", path='").append(this.path).append('\'');
        sb.append(", projectId=").append(this.projectId);
        sb.append(", seq=").append(this.seq);
        sb.append(", id=").append(this.id);
        sb.append('}');
        return sb.toString();
    }
}

