/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.component.service;

import com.shimi.gogoscrum.common.service.BaseServiceImpl;
import com.shimi.gogoscrum.component.model.Component;
import com.shimi.gogoscrum.component.model.ComponentFilter;
import com.shimi.gogoscrum.component.repository.ComponentRepository;
import com.shimi.gogoscrum.component.service.ComponentService;
import com.shimi.gsf.core.exception.BaseServiceException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ComponentServiceImpl
extends BaseServiceImpl<Component, ComponentFilter>
implements ComponentService {
    private static final Logger log = LoggerFactory.getLogger(ComponentServiceImpl.class);
    @Autowired
    private ComponentRepository repository;

    protected ComponentRepository getRepository() {
        return this.repository;
    }

    public void updateSeq(List<Long> componentIds) {
        AtomicInteger i = new AtomicInteger();
        List categories = componentIds.stream().map(id -> {
            Component cat = (Component)this.get(id);
            cat.setSeq(Integer.valueOf(i.getAndIncrement()));
            return cat;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(categories)) {
            this.repository.saveAll(categories);
            log.info("Updated components seq for {}", componentIds);
        }
    }

    public List<Component> findByProjectId(Long projectId) {
        return this.repository.findByProjectId(projectId);
    }

    protected void beforeCreate(Component component) {
        Long parentId = component.getParentId();
        if (parentId == null || parentId <= 0L) {
            component.setParentId(null);
            component.setPath("/");
        } else {
            Component parent = (Component)this.get(parentId);
            component.setPath(parent.getFullPath());
        }
    }

    protected void beforeDelete(Component component) {
        Long childrenCount = this.repository.countByParentId(component.getId());
        if (childrenCount > 0L) {
            throw new BaseServiceException("hasChildren", "Component has children and cannot be deleted", HttpStatus.PRECONDITION_FAILED);
        }
    }

    protected Specification<Component> toSpec(ComponentFilter filter) {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

