/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.shimi.gogoscrum.config.SpaCsrfTokenRequestHandler;
import com.shimi.gogoscrum.user.authentication.AuthenticationHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.rememberme.TokenBasedRememberMeServices;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@EnableWebSecurity
@EnableScheduling
public class WebSecurityConfig {
    private static final Logger log = LoggerFactory.getLogger(WebSecurityConfig.class);
    @Autowired
    private AuthenticationSuccessHandler authenticationSuccessHandler;
    @Autowired
    private AuthenticationFailureHandler authenticationFailureHandler;
    @Autowired
    private AuthenticationHandler logoutSuccessHandler;
    @Autowired
    private UserDetailsService userService;
    @Value(value="${security.config.rememberMeKey}")
    private String rememberMeKey;

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        String[] csrfIgnores = new String[]{"/files/upload"};
        String[] publicApis = new String[]{"/swagger-ui/**", "/v3/api-docs/**", "/health", "/csrf", "/users/register", "/users/login", "/users/oauth/**", "/docs/view/**"};
        http.cors(cors -> cors.configurationSource(this.corsConfigurationSource())).csrf(csrf -> csrf.ignoringRequestMatchers(csrfIgnores).csrfTokenRepository((CsrfTokenRepository)CookieCsrfTokenRepository.withHttpOnlyFalse()).csrfTokenRequestHandler((CsrfTokenRequestHandler)new SpaCsrfTokenRequestHandler())).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(publicApis)).permitAll().anyRequest()).authenticated()).formLogin(formLogin -> ((FormLoginConfigurer)formLogin.successHandler(this.authenticationSuccessHandler)).failureHandler(this.authenticationFailureHandler)).logout(logout -> logout.logoutSuccessHandler((LogoutSuccessHandler)this.logoutSuccessHandler)).exceptionHandling(exceptionHandling -> exceptionHandling.authenticationEntryPoint(this.authenticationEntryPoint()).accessDeniedHandler(this.getAccessDeniedHandler())).rememberMe(rememberMe -> rememberMe.rememberMeServices((RememberMeServices)this.rememberMeServices()));
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public AccessDeniedHandler getAccessDeniedHandler() {
        return (request, response, accessDeniedException) -> {
            log.trace("Resource AccessDeniedException: ", (Throwable)accessDeniedException);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("message", accessDeniedException.getMessage());
            ObjectMapper mapper = new ObjectMapper();
            response.getWriter().append(mapper.writeValueAsString(map));
            response.setContentType("application/json");
            response.setStatus(403);
        };
    }

    @Bean
    public AuthenticationEntryPoint authenticationEntryPoint() {
        return (request, response, authException) -> {
            log.trace("Resource AccessDeniedException: ", (Throwable)authException);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("message", authException.getMessage());
            ObjectMapper mapper = new ObjectMapper();
            response.getWriter().append(mapper.writeValueAsString(map));
            response.setContentType("application/json");
            response.setStatus(401);
        };
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOrigins(List.of("*"));
        configuration.setAllowedMethods(Arrays.asList("GET", "POST", "PUT", "DELETE", "OPTIONS"));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }

    @Bean
    public TokenBasedRememberMeServices rememberMeServices() {
        TokenBasedRememberMeServices tokenBasedRememberMeServices = new TokenBasedRememberMeServices(this.rememberMeKey, this.userService);
        tokenBasedRememberMeServices.setParameter("rememberMe");
        tokenBasedRememberMeServices.setTokenValiditySeconds(864000);
        return tokenBasedRememberMeServices;
    }
}

