/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.doc.controller;

import com.shimi.gogoscrum.common.controller.BaseController;
import com.shimi.gogoscrum.doc.dto.DocDto;
import com.shimi.gogoscrum.doc.model.Doc;
import com.shimi.gogoscrum.doc.model.DocFilter;
import com.shimi.gogoscrum.doc.service.DocService;
import com.shimi.gsf.core.dto.Dto;
import com.shimi.gsf.core.dto.DtoQueryResult;
import com.shimi.gsf.core.model.Entity;
import com.shimi.gsf.core.model.EntityQueryResult;
import com.shimi.gsf.core.model.Filter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/docs"})
@CrossOrigin
@Tag(name="Doc", description="Doc management")
@RolesAllowed(value={"ROLE_USER"})
public class DocController
extends BaseController {
    @Autowired
    private DocService docService;

    @Operation(summary="Create a new doc")
    @PostMapping
    public DocDto create(@RequestBody DocDto docDto) {
        Doc saveFile = (Doc)this.docService.create((Entity)docDto.toEntity());
        return saveFile.toDto();
    }

    @Operation(summary="Get doc by ID")
    @Parameters(value={@Parameter(name="id", description="The doc ID")})
    @GetMapping(value={"/{id}"})
    public DocDto get(@PathVariable Long id) {
        Doc doc = (Doc)this.docService.get(id);
        return doc.toDto(true);
    }

    @Operation(summary="Get doc by ID, this API is for public access")
    @Parameters(value={@Parameter(name="id", description="The doc ID")})
    @GetMapping(value={"/view/{id}"})
    @PermitAll
    public DocDto getAsPublic(@PathVariable Long id) {
        Doc doc = (Doc)this.docService.get(id);
        return doc.toDto(true);
    }

    @Operation(summary="Update doc to public access")
    @Parameters(value={@Parameter(name="id", description="The doc ID")})
    @PostMapping(value={"/{id}/public"})
    public DocDto setPublicAccess(@PathVariable Long id) {
        return this.docService.updatePublicAccess(id, Boolean.TRUE).toDto(true);
    }

    @Operation(summary="Update doc to private access")
    @Parameters(value={@Parameter(name="id", description="The doc ID")})
    @DeleteMapping(value={"/{id}/public"})
    public DocDto deletePublicAccess(@PathVariable Long id) {
        return this.docService.updatePublicAccess(id, Boolean.FALSE).toDto(true);
    }

    @Operation(summary="Update an existing doc")
    @Parameters(value={@Parameter(name="id", description="The doc ID")})
    @PostMapping(value={"/{id}"})
    public DocDto updateDoc(@PathVariable Long id, @RequestBody DocDto docDto) {
        Doc saveFile = (Doc)this.docService.update(id, (Entity)docDto.toEntity());
        return saveFile.toDto();
    }

    @Operation(summary="Delete an existing doc")
    @Parameters(value={@Parameter(name="id", description="The doc ID")})
    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable Long id) {
        this.docService.delete(id);
    }

    @Operation(summary="Search docs")
    @Parameters(value={@Parameter(name="filter", description="The search filter")})
    @GetMapping
    public DtoQueryResult<Dto> search(DocFilter filter) {
        EntityQueryResult queryResult = this.docService.search((Filter)Objects.requireNonNullElse(filter, new DocFilter()));
        return queryResult.toDto();
    }
}

