/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.doc.service;

import com.shimi.gogoscrum.common.service.BaseServiceImpl;
import com.shimi.gogoscrum.doc.model.Doc;
import com.shimi.gogoscrum.doc.model.DocFilter;
import com.shimi.gogoscrum.doc.repository.DocRepository;
import com.shimi.gogoscrum.doc.repository.DocSpecs;
import com.shimi.gogoscrum.doc.service.DocService;
import com.shimi.gogoscrum.project.model.Project;
import com.shimi.gogoscrum.project.service.ProjectService;
import com.shimi.gogoscrum.project.utils.ProjectMemberUtils;
import com.shimi.gogoscrum.user.model.User;
import com.shimi.gsf.core.exception.BaseServiceException;
import com.shimi.gsf.core.model.Entity;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DocServiceImpl
extends BaseServiceImpl<Doc, DocFilter>
implements DocService {
    @Autowired
    private DocRepository repository;
    @Autowired
    private ProjectService projectService;

    protected DocRepository getRepository() {
        return this.repository;
    }

    public Doc get(Long id) {
        Doc doc = (Doc)super.get(id);
        if (doc.getPublicAccess().booleanValue()) {
            return doc;
        }
        User currentUser = this.getCurrentUser();
        if (currentUser != null) {
            ProjectMemberUtils.checkMember((Project)((Project)this.projectService.get(doc.getProjectId())), (User)currentUser);
            return doc;
        }
        throw new BaseServiceException("userUnauthorized", "Unauthorized cannot access private document", HttpStatus.UNAUTHORIZED);
    }

    public Doc updatePublicAccess(Long id, Boolean publicAccess) {
        Doc existingDoc = this.get(id);
        existingDoc.setPublicAccess(publicAccess);
        return (Doc)this.update(id, (Entity)existingDoc);
    }

    protected Specification<Doc> toSpec(DocFilter filter) {
        Specification querySpec = null;
        if (filter.getProjectId() != null) {
            querySpec = DocSpecs.projectIdEqual((Long)filter.getProjectId());
        }
        if (StringUtils.hasText((String)filter.getKeyword())) {
            Specification nameLike = DocSpecs.nameLike((String)filter.getKeyword());
            querySpec = Objects.isNull(querySpec) ? nameLike : querySpec.and(nameLike);
        }
        return querySpec;
    }

    protected void beforeCreate(Doc doc) {
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(doc.getProjectId())), (User)this.getCurrentUser());
    }

    protected void beforeUpdate(Long id, Doc existingEntity, Doc newEntity) {
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(existingEntity.getProjectId())), (User)this.getCurrentUser());
    }

    protected void beforeDelete(Doc doc) {
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(doc.getProjectId())), (User)this.getCurrentUser());
    }
}

