/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.file.controller;

import com.shimi.gogoscrum.common.controller.BaseController;
import com.shimi.gogoscrum.file.dto.FileDto;
import com.shimi.gogoscrum.file.model.File;
import com.shimi.gogoscrum.file.model.FileFilter;
import com.shimi.gogoscrum.file.model.FileUploadToken;
import com.shimi.gogoscrum.file.model.TargetType;
import com.shimi.gogoscrum.file.service.FileService;
import com.shimi.gsf.core.dto.Dto;
import com.shimi.gsf.core.dto.DtoQueryResult;
import com.shimi.gsf.core.model.Entity;
import com.shimi.gsf.core.model.EntityQueryResult;
import com.shimi.gsf.core.model.Filter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/files"})
@CrossOrigin
@Tag(name="File", description="File management")
@RolesAllowed(value={"ROLE_USER"})
public class FileController
extends BaseController {
    @Autowired
    private FileService fileService;

    @Operation(summary="Generate upload token")
    @Parameters(value={@Parameter(name="fileName", description="The original file name"), @Parameter(name="projectId", description="The project ID (optional)"), @Parameter(name="targetType", description="The target type")})
    @GetMapping(value={"/token"})
    public FileUploadToken generateUploadToken(@RequestParam String fileName, @RequestParam(required=false) Long projectId, @RequestParam TargetType targetType) {
        return this.fileService.generateUploadToken(fileName, projectId, targetType);
    }

    @Operation(summary="Upload a file, returning the file URL")
    @Parameters(value={@Parameter(name="file", description="The file to upload"), @Parameter(name="path", description="The path where the file will be saved"), @Parameter(name="targetFileName", description="The target file name")})
    @PostMapping(value={"/upload"})
    public String upload(@RequestParam MultipartFile file, @RequestParam String path, @RequestParam String targetFileName) {
        return this.fileService.upload(file, path, targetFileName);
    }

    @Operation(summary="Create a new file")
    @PostMapping
    public FileDto create(@RequestBody FileDto fileDto) {
        File saveFile = (File)this.fileService.create((Entity)fileDto.toEntity());
        return saveFile.toDto();
    }

    @Operation(summary="Update an existing file")
    @Parameters(value={@Parameter(name="id", description="The file ID")})
    @PutMapping(value={"/{id}"})
    public FileDto update(@PathVariable Long id, @RequestBody FileDto fileDto) {
        File saveFile = (File)this.fileService.update(id, (Entity)fileDto.toEntity());
        return saveFile.toDto();
    }

    @Operation(summary="Delete an existing file")
    @Parameters(value={@Parameter(name="id", description="The file ID")})
    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable Long id) {
        this.fileService.delete(id);
    }

    @Operation(summary="Get file by ID")
    @Parameters(value={@Parameter(name="id", description="The file ID")})
    @GetMapping(value={"/{id}"})
    public FileDto get(@PathVariable Long id) {
        return ((File)this.fileService.get(id)).toDto(true, Integer.MAX_VALUE);
    }

    @Operation(summary="Delete File by path")
    @Parameters(value={@Parameter(name="path", description="The file path")})
    @DeleteMapping
    public void delete(@RequestParam String path) {
        this.fileService.deleteByPath(path);
    }

    @Operation(summary="Search files")
    @Parameters(value={@Parameter(name="filter", description="The search filter")})
    @GetMapping
    public DtoQueryResult<Dto> search(FileFilter filter) {
        EntityQueryResult queryResult = this.fileService.search((Filter)Objects.requireNonNullElse(filter, new FileFilter()));
        return queryResult.toDto();
    }
}

