/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.file.model;

import com.shimi.gogoscrum.common.model.BaseEntity;
import com.shimi.gogoscrum.file.dto.FileDto;
import com.shimi.gogoscrum.file.model.FileType;
import com.shimi.gogoscrum.file.model.TargetType;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.util.Objects;
import org.springframework.beans.BeanUtils;

@Entity
public class File
extends BaseEntity {
    private static final long serialVersionUID = -4096920558859114260L;
    private String name;
    private String fullPath;
    private String urlPrefix;
    @Enumerated(value=EnumType.STRING)
    private FileType type;
    @Enumerated(value=EnumType.STRING)
    private TargetType targetType;
    private Long size;
    private String storageProvider;
    private Boolean folder = Boolean.FALSE;
    private Long projectId;
    @ManyToOne
    @JoinColumn(name="parent_id")
    private File parent;

    public FileDto toDto() {
        return this.toDto(false);
    }

    public FileDto toDto(boolean detailed) {
        return this.toDto(detailed, 1);
    }

    public FileDto toDto(boolean detailed, int ancestorLevel) {
        FileDto dto = new FileDto();
        BeanUtils.copyProperties((Object)this, (Object)dto);
        if (this.createdBy != null) {
            dto.setCreatedBy(this.createdBy.toDto().normalize());
        }
        if (this.parent != null && ancestorLevel > 0) {
            dto.setParent(this.parent.toDto(detailed, ancestorLevel - 1));
        }
        return dto;
    }

    public File() {
    }

    public File(Long id) {
        this.id = id;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public void setUrlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    public FileType getType() {
        return this.type;
    }

    public void setType(FileType type) {
        this.type = type;
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public void setTargetType(TargetType targetType) {
        this.targetType = targetType;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Boolean getFolder() {
        return this.folder;
    }

    public void setFolder(Boolean folder) {
        this.folder = folder;
    }

    public File getParent() {
        return this.parent;
    }

    public void setParent(File parent) {
        this.parent = parent;
    }

    public String getStorageProvider() {
        return this.storageProvider;
    }

    public void setStorageProvider(String storageProvider) {
        this.storageProvider = storageProvider;
    }

    public String getUrl() {
        if (this.fullPath == null || this.fullPath.isEmpty()) {
            return null;
        }
        if (this.fullPath.startsWith("http://") || this.fullPath.startsWith("https://")) {
            return this.fullPath;
        }
        return Objects.requireNonNullElse(this.urlPrefix, "/") + this.fullPath;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("File{");
        sb.append("id=").append(this.id);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", folder=").append(this.folder);
        sb.append(", type=").append(this.type);
        sb.append(", size=").append(this.size);
        sb.append(", projectId=").append(this.projectId);
        sb.append(", targetType=").append(this.targetType);
        sb.append(", path='").append(this.fullPath).append('\'');
        sb.append(", urlPrefix='").append(this.urlPrefix).append('\'');
        sb.append(", storage=").append(this.storageProvider);
        sb.append('}');
        return sb.toString();
    }
}

