/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.file.service;

import com.shimi.gogoscrum.common.model.BaseEntity;
import com.shimi.gogoscrum.common.service.BaseServiceImpl;
import com.shimi.gogoscrum.common.util.FileUtil;
import com.shimi.gogoscrum.common.util.PermissionUtil;
import com.shimi.gogoscrum.file.model.File;
import com.shimi.gogoscrum.file.model.FileFilter;
import com.shimi.gogoscrum.file.model.FileUploadToken;
import com.shimi.gogoscrum.file.model.TargetType;
import com.shimi.gogoscrum.file.repository.FileRepository;
import com.shimi.gogoscrum.file.repository.FileSpecs;
import com.shimi.gogoscrum.file.service.FileService;
import com.shimi.gogoscrum.file.service.FileStorage;
import com.shimi.gogoscrum.project.model.Project;
import com.shimi.gogoscrum.project.service.ProjectService;
import com.shimi.gogoscrum.project.utils.ProjectMemberUtils;
import com.shimi.gogoscrum.user.model.User;
import com.shimi.gsf.core.exception.BaseServiceException;
import com.shimi.gsf.core.exception.EntityNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileServiceImpl
extends BaseServiceImpl<File, FileFilter>
implements FileService {
    public static final Logger log = LoggerFactory.getLogger(FileServiceImpl.class);
    @Autowired
    private FileRepository repository;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private FileStorage fileStorage;
    @Autowired
    private PluginManager pluginManager;
    private final Map<String, FileStorage> fileStorageServices = new HashMap();

    @PostConstruct
    private void initPlugins() {
        this.fileStorageServices.put(this.fileStorage.getProvider(), this.fileStorage);
        List fileStoragePlugins = this.pluginManager.getExtensions(FileStorage.class);
        if (!fileStoragePlugins.isEmpty()) {
            this.fileStorageServices.putAll(fileStoragePlugins.stream().collect(Collectors.toMap(FileStorage::getProvider, fs -> fs)));
            this.fileStorage = (FileStorage)fileStoragePlugins.getFirst();
            if (fileStoragePlugins.size() > 1) {
                log.warn("Multiple file storage plugins found. The first one {} will be used as the storage provider", (Object)this.fileStorage.getProvider());
            } else {
                log.info("File storage plugin {} found and will be used as storage provider", (Object)this.fileStorage.getProvider());
            }
        }
    }

    protected FileRepository getRepository() {
        return this.repository;
    }

    public FileUploadToken generateUploadToken(String originalFileName, Long projectId, TargetType targetType) {
        if (targetType == null) {
            throw new BaseServiceException("invalidRequestData", "Target type is required", HttpStatus.BAD_REQUEST);
        }
        if (!targetType.equals((Object)TargetType.USER_AVATAR) && projectId == null) {
            throw new BaseServiceException("invalidRequestData", "Project ID is required for this target type", HttpStatus.BAD_REQUEST);
        }
        if (targetType.equals((Object)TargetType.USER_AVATAR) && projectId != null) {
            throw new BaseServiceException("invalidRequestData", "Project ID should not be provided for user avatar uploads", HttpStatus.BAD_REQUEST);
        }
        if (!StringUtils.hasText((String)originalFileName)) {
            throw new BaseServiceException("invalidRequestData", "File name is empty", HttpStatus.BAD_REQUEST);
        }
        if (projectId != null) {
            Project project = (Project)this.projectService.get(projectId);
            ProjectMemberUtils.checkDeveloper((Project)project, (User)this.getCurrentUser());
        }
        String targetFileName = FileUtil.generateRandomFileName((String)FileUtil.getExt((String)originalFileName));
        String subPath = "/" + targetType.name().toLowerCase();
        String path = projectId != null ? "/projects/" + projectId + subPath : subPath;
        FileUploadToken token = this.fileStorage.generateUploadToken(originalFileName, path, targetFileName);
        token.setPath(path);
        token.setSourceFileName(originalFileName);
        token.setTargetFileName(targetFileName);
        token.setProjectId(projectId);
        token.setTargetType(targetType);
        if (log.isDebugEnabled()) {
            log.debug("Generated file upload token: {}", (Object)token);
        }
        return token;
    }

    public String upload(MultipartFile multipartFile, String path, String targetFileName) {
        if (multipartFile.isEmpty()) {
            throw new BaseServiceException("invalidRequestData", "File is empty", HttpStatus.BAD_REQUEST);
        }
        if (!StringUtils.hasText((String)path)) {
            throw new BaseServiceException("invalidRequestData", "Upload path is required", HttpStatus.BAD_REQUEST);
        }
        if (!StringUtils.hasText((String)targetFileName)) {
            throw new BaseServiceException("invalidRequestData", "Target file name is required", HttpStatus.BAD_REQUEST);
        }
        try {
            return this.fileStorage.upload(multipartFile.getInputStream(), path, targetFileName);
        }
        catch (IOException e) {
            throw new BaseServiceException("fileUploadError", "Failed to save uploaded file: " + multipartFile.getOriginalFilename(), HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    public File get(Long id) {
        File file = (File)super.get(id);
        if (file.getProjectId() != null) {
            ProjectMemberUtils.checkMember((Project)((Project)this.projectService.get(file.getProjectId())), (User)this.getCurrentUser());
        }
        return file;
    }

    public void deleteByPath(String path) {
        File file = this.repository.findByFullPath(path);
        if (file == null) {
            throw new EntityNotFoundException("File not found by path " + path);
        }
        super.delete(file.getId());
    }

    protected Specification<File> toSpec(FileFilter filter) {
        Specification querySpec = null;
        if (filter.getProjectId() != null) {
            querySpec = FileSpecs.projectIdEqual((Long)filter.getProjectId());
        }
        if (filter.getParentId() != null) {
            Specification parentIdEqual = FileSpecs.parentIdEqual((Long)filter.getParentId());
            querySpec = Objects.isNull(querySpec) ? parentIdEqual : querySpec.and(parentIdEqual);
        } else if (filter.isRootLevel()) {
            Specification parentIdNull = FileSpecs.parentIdNull();
            Specification specification = querySpec = Objects.isNull(querySpec) ? parentIdNull : querySpec.and(parentIdNull);
        }
        if (StringUtils.hasText((String)filter.getKeyword())) {
            Specification nameLike = FileSpecs.nameLike((String)filter.getKeyword());
            Specification specification = querySpec = Objects.isNull(querySpec) ? nameLike : querySpec.and(nameLike);
        }
        if (filter.getTargetType() != null) {
            Specification targetTypeEqual = FileSpecs.targetTypeEqual((TargetType)filter.getTargetType());
            querySpec = Objects.isNull(querySpec) ? targetTypeEqual : querySpec.and(targetTypeEqual);
        }
        return querySpec;
    }

    protected void beforeCreate(File file) {
        if (file.getProjectId() != null) {
            ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(file.getProjectId())), (User)this.getCurrentUser());
        }
        if (file.getFolder().booleanValue() && file.getTargetType() == null) {
            file.setTargetType(TargetType.PROJECT_FILE);
        }
    }

    protected void beforeUpdate(Long id, File existingEntity, File newEntity) {
        if (existingEntity.getProjectId() != null) {
            ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(existingEntity.getProjectId())), (User)this.getCurrentUser());
        }
        BeanUtils.copyProperties((Object)existingEntity, (Object)newEntity, (String[])new String[]{"name", "parent"});
    }

    protected void beforeDelete(File file) {
        List children;
        if (file.getProjectId() != null) {
            if (Objects.equals(file.getTargetType(), TargetType.PROJECT_AVATAR)) {
                ProjectMemberUtils.checkOwner((Project)((Project)this.projectService.get(file.getProjectId())), (User)this.getCurrentUser());
            } else {
                ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(file.getProjectId())), (User)this.getCurrentUser());
            }
        } else {
            PermissionUtil.checkOwnership((BaseEntity)file, (User)this.getCurrentUser());
        }
        if (file.getFolder().booleanValue() && !(children = this.findAllChildren(file)).isEmpty()) {
            children.forEach(child -> this.delete(child.getId()));
            log.info("Delete {} children of folder {}", (Object)children.size(), (Object)file);
        }
    }

    private List<File> findAllChildren(File folder) {
        FileFilter filter = new FileFilter();
        filter.setParentId(folder.getId());
        Specification querySpec = this.toSpec(filter);
        return this.repository.findAll(querySpec);
    }

    protected void afterDelete(File file) {
        if (StringUtils.hasText((String)file.getFullPath())) {
            if (Objects.equals(file.getStorageProvider(), this.fileStorage.getProvider())) {
                this.fileStorage.delete(file.getFullPath());
            } else if (this.fileStorageServices.containsKey(file.getStorageProvider())) {
                FileStorage oldFileStorage = (FileStorage)this.fileStorageServices.get(file.getStorageProvider());
                oldFileStorage.delete(file.getFullPath());
            } else {
                log.warn("The old file storage service {} does not match current storage service {}, and the old storage service is not presented, skipping deletion from the storage.", (Object)file.getStorageProvider(), (Object)this.fileStorage.getProvider());
            }
        }
    }
}

