/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.history.service;

import com.shimi.gogoscrum.common.service.BaseServiceImpl;
import com.shimi.gogoscrum.history.model.Historical;
import com.shimi.gogoscrum.history.model.History;
import com.shimi.gogoscrum.history.model.HistoryFilter;
import com.shimi.gogoscrum.history.repository.HistoryRepository;
import com.shimi.gogoscrum.history.repository.HistorySpecs;
import com.shimi.gogoscrum.history.service.HistoryService;
import com.shimi.gsf.core.event.EntityChangeEvent;
import com.shimi.gsf.core.model.Entity;
import com.shimi.gsf.core.model.User;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.bitbucket.cowwoc.diffmatchpatch.DiffMatchPatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class HistoryServiceImpl
extends BaseServiceImpl<History, HistoryFilter>
implements HistoryService {
    public static final Logger log = LoggerFactory.getLogger(HistoryServiceImpl.class);
    @Autowired
    private HistoryRepository repository;

    protected HistoryRepository getRepository() {
        return this.repository;
    }

    @EventListener
    @Transactional(propagation=Propagation.REQUIRED)
    public void onEntityChanged(EntityChangeEvent event) {
        Entity entity = Objects.requireNonNullElse(event.getPreviousEntity(), event.getUpdatedEntity());
        if (!(entity instanceof Historical)) {
            return;
        }
        EntityChangeEvent.ActionType actionType = event.getActionType();
        History history = new History();
        String historyDetails = this.getDiff(event.getPreviousEntity(), event.getUpdatedEntity());
        if (StringUtils.hasText((String)historyDetails)) {
            history.setActionType(actionType);
            history.setEntityId(entity.getId());
            history.setEntityType(entity.getClass().getName());
            history.setDetails(historyDetails);
            history.setAllTraceInfo((User)this.getCurrentUser());
            this.create((Entity)history);
        }
    }

    private String getDiff(Entity previousEntity, Entity updatedEntity) {
        DiffMatchPatch diffMatchPatch = new DiffMatchPatch();
        LinkedList diffs = diffMatchPatch.diffMain(previousEntity != null ? ((Historical)previousEntity).getDetails() : "", updatedEntity != null ? ((Historical)updatedEntity).getDetails() : "", false);
        boolean changed = diffs.stream().anyMatch(diff -> !diff.operation.equals((Object)DiffMatchPatch.Operation.EQUAL));
        if (changed) {
            return diffMatchPatch.diffPrettyHtml((List)diffs);
        }
        return null;
    }

    protected Specification<History> toSpec(HistoryFilter filter) {
        Specification querySpec = null;
        if (StringUtils.hasText((String)filter.getEntityType())) {
            querySpec = HistorySpecs.entityTypeEqual((String)filter.getEntityType());
        }
        if (filter.getEntityId() != null) {
            Specification entityIdEqual = HistorySpecs.entityIdEqual((Long)filter.getEntityId());
            Specification specification = querySpec = Objects.isNull(querySpec) ? entityIdEqual : querySpec.and(entityIdEqual);
        }
        if (filter.getActionType() != null) {
            Specification actionTypeEqual = HistorySpecs.actionTypeEqual((EntityChangeEvent.ActionType)filter.getActionType());
            querySpec = Objects.isNull(querySpec) ? actionTypeEqual : querySpec.and(actionTypeEqual);
        }
        return querySpec;
    }
}

