/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.issue.controller;

import com.shimi.gogoscrum.common.controller.BaseController;
import com.shimi.gogoscrum.issue.dto.CommentDto;
import com.shimi.gogoscrum.issue.model.Comment;
import com.shimi.gogoscrum.issue.service.CommentService;
import com.shimi.gsf.core.model.Entity;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/comments"})
@CrossOrigin
@Tag(name="Issue comment", description="Issue comment management")
@RolesAllowed(value={"ROLE_USER"})
public class CommentController
extends BaseController {
    @Autowired
    private CommentService commentService;

    @Operation(summary="Create a new comment")
    @PostMapping
    public CommentDto create(@RequestBody CommentDto commentDto) {
        Comment savedComment = (Comment)this.commentService.create((Entity)commentDto.toEntity());
        return savedComment.toDto();
    }

    @Operation(summary="Update an existing comment")
    @Parameters(value={@Parameter(name="id", description="The comment ID")})
    @PostMapping(value={"/{id}"})
    public CommentDto update(@PathVariable Long id, @RequestBody CommentDto commentDto) {
        Comment updatedComment = (Comment)this.commentService.update(id, (Entity)commentDto.toEntity());
        return updatedComment.toDto();
    }

    @Operation(summary="Get a comment")
    @Parameters(value={@Parameter(name="id", description="The comment ID")})
    @GetMapping(value={"/{id}"})
    public CommentDto get(@PathVariable Long id) {
        Comment comment = (Comment)this.commentService.get(id);
        return comment.toDto(true);
    }

    @Operation(summary="Delete a comment")
    @Parameters(value={@Parameter(name="id", description="The comment ID")})
    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable Long id) {
        this.commentService.delete(id);
    }
}

