/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.issue.controller;

import com.shimi.gogoscrum.common.controller.BaseController;
import com.shimi.gogoscrum.file.dto.FileDto;
import com.shimi.gogoscrum.history.model.HistoryFilter;
import com.shimi.gogoscrum.history.service.HistoryService;
import com.shimi.gogoscrum.issue.dto.IssueDto;
import com.shimi.gogoscrum.issue.dto.IssueFilterDto;
import com.shimi.gogoscrum.issue.model.Issue;
import com.shimi.gogoscrum.issue.service.IssueService;
import com.shimi.gsf.core.dto.Dto;
import com.shimi.gsf.core.dto.DtoQueryResult;
import com.shimi.gsf.core.model.Entity;
import com.shimi.gsf.core.model.EntityQueryResult;
import com.shimi.gsf.core.model.Filter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/issues"})
@CrossOrigin
@Tag(name="Issue", description="Issue management")
@RolesAllowed(value={"ROLE_USER"})
public class IssueController
extends BaseController {
    @Autowired
    private IssueService issueService;
    @Autowired
    private HistoryService historyService;

    @Operation(summary="Create new issue")
    @PostMapping
    public IssueDto create(@RequestBody IssueDto issueDto) {
        Issue saveIssue = (Issue)this.issueService.create((Entity)issueDto.toEntity());
        return saveIssue.toDto();
    }

    @Operation(summary="Put issue into the specified group")
    @Parameters(value={@Parameter(name="id", description="Issue ID"), @Parameter(name="groupId", description="The ID of the destination group")})
    @PostMapping(value={"/{id}/move/{groupId}"})
    public IssueDto moveIssueToGroup(@PathVariable Long id, @PathVariable Long groupId) {
        Issue saveIssue = this.issueService.moveIssueToGroup(id, groupId);
        return saveIssue.toDto(true);
    }

    @Operation(summary="Assign issue to user")
    @Parameters(value={@Parameter(name="id", description="Issue ID"), @Parameter(name="userId", description="The ID of the new owner")})
    @PostMapping(value={"/{id}/owner/{userId}"})
    public IssueDto assign(@PathVariable Long id, @PathVariable Long userId) {
        Issue saveIssue = this.issueService.assignTo(id, userId);
        return saveIssue.toDto(true);
    }

    @Operation(summary="Unassign an issue from the owner")
    @Parameters(value={@Parameter(name="id", description="Issue ID")})
    @DeleteMapping(value={"/{id}/owner"})
    public IssueDto unassign(@PathVariable Long id) {
        Issue saveIssue = this.issueService.unassign(id);
        return saveIssue.toDto(true);
    }

    @Operation(summary="Update an issue")
    @Parameters(value={@Parameter(name="id", description="Issue ID")})
    @PutMapping(value={"/{id}"})
    public IssueDto update(@PathVariable Long id, @RequestBody IssueDto issueDto) {
        Issue saveIssue = (Issue)this.issueService.update(id, (Entity)issueDto.toEntity());
        return saveIssue.toDto(true);
    }

    @Operation(summary="Copy an issue", description="Copy the specified issue with all properties except comments and files")
    @Parameters(value={@Parameter(name="id", description="The original issue ID")})
    @PostMapping(value={"/{id}/clone"})
    public IssueDto clone(@PathVariable Long id) {
        Issue clonedIssue = this.issueService.cloneIssue(id);
        return clonedIssue.toDto(true);
    }

    @Operation(summary="Get Issue by ID")
    @Parameters(value={@Parameter(name="id", description="Issue ID")})
    @GetMapping(value={"/{id}"})
    public IssueDto get(@PathVariable Long id) {
        Issue issue = (Issue)this.issueService.get(id);
        return issue.toDto(true);
    }

    @Operation(summary="Delete Issue By ID")
    @Parameters(value={@Parameter(name="id", description="Issue ID")})
    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable Long id) {
        this.issueService.delete(id);
    }

    @Operation(summary="Add issue attachment")
    @Parameters(value={@Parameter(name="id", description="The issue ID"), @Parameter(name="fileDto", description="The file to attach")})
    @PostMapping(value={"/{id}/files"})
    public FileDto addFile(@PathVariable Long id, @RequestBody FileDto fileDto) {
        return this.issueService.addFile(id, fileDto.toEntity()).toDto();
    }

    @Operation(summary="Delete issue attachment")
    @Parameters(value={@Parameter(name="id", description="The issue ID"), @Parameter(name="fileId", description="The file ID")})
    @DeleteMapping(value={"/{id}/files/{fileId}"})
    public void deleteFile(@PathVariable Long id, @PathVariable Long fileId) {
        this.issueService.deleteFile(id, fileId);
    }

    @Operation(summary="Get issue changes history")
    @Parameters(value={@Parameter(name="id", description="The issue ID"), @Parameter(name="filter", description="The query filter")})
    @GetMapping(value={"/{id}/histories"})
    public DtoQueryResult<Dto> searchHistories(@PathVariable Long id, HistoryFilter filter) {
        filter = Objects.requireNonNullElse(filter, new HistoryFilter());
        filter.setEntityId(id);
        filter.setEntityType(Issue.class.getName());
        EntityQueryResult queryResult = this.historyService.search((Filter)filter);
        return queryResult.toDto();
    }

    @Operation(summary="Batch update issue sequence")
    @Parameters(value={@Parameter(name="issueIds", description="Update the issues seq to the same as the IDs of the passed in parameter ")})
    @PostMapping(value={"/seq"})
    public void updateSeq(@RequestBody List<Long> issueIds) {
        if (!CollectionUtils.isEmpty(issueIds)) {
            this.issueService.updateIssuesSeq(issueIds);
        }
    }

    @Operation(summary="Link an issue to another")
    @Parameters(value={@Parameter(name="fromId", description="The source issue ID"), @Parameter(name="toId", description="The target issue ID")})
    @PostMapping(value={"/{fromId}/links/{toId}"})
    public void link(@PathVariable(value="fromId") Long fromId, @PathVariable(value="toId") Long toId) {
        this.issueService.linkIssue(fromId, toId);
    }

    @Operation(summary="Unlink an issue to another")
    @Parameters(value={@Parameter(name="fromId", description="The source issue ID"), @Parameter(name="toId", description="The target issue ID")})
    @DeleteMapping(value={"/{fromId}/links/{toId}"})
    public void unlink(@PathVariable(value="fromId") Long fromId, @PathVariable(value="toId") Long toId) {
        this.issueService.unlinkIssue(fromId, toId);
    }

    @Operation(summary="Search issues")
    @Parameters(value={@Parameter(name="filter", description="The search filter")})
    @PostMapping(value={"/search"})
    public DtoQueryResult<Dto> searchIssues(@RequestBody IssueFilterDto filter) {
        filter = Objects.requireNonNullElse(filter, new IssueFilterDto());
        EntityQueryResult queryResult = this.issueService.search((Filter)filter.toEntity());
        return queryResult.toDto();
    }

    @Operation(summary="Batch move issues into a sprint")
    @Parameters(value={@Parameter(name="sprintId", description="Target sprint ID")})
    @PostMapping(value={"/move/batch/{sprintId}"})
    public void moveAll(@PathVariable(value="sprintId") Long sprintId, @RequestBody List<Long> issueIds) {
        this.issueService.moveIssuesToSprint(issueIds, sprintId);
    }

    @Operation(summary="Export issues")
    @Parameters(value={@Parameter(name="filter", description="The search filter")})
    @PostMapping(value={"/export"})
    public ResponseEntity<Resource> exportIssues(@RequestBody IssueFilterDto filter) {
        filter = Objects.requireNonNullElse(filter, new IssueFilterDto());
        byte[] bytes = this.issueService.export(filter.toEntity());
        ByteArrayResource resource = new ByteArrayResource(bytes);
        String today = new SimpleDateFormat("yyyyMMddHHmm").format(new Date());
        String filename = String.format("issues-exported-%s.xlsx", today);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)"application/vnd.ms-excel")).header("Content-Disposition", new String[]{"attachment; filename=" + filename})).body((Object)resource);
    }
}

