/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.issue.controller;

import com.shimi.gogoscrum.common.controller.BaseController;
import com.shimi.gogoscrum.issue.dto.IssueFilterDto;
import com.shimi.gogoscrum.issue.model.IssueFilter;
import com.shimi.gogoscrum.issue.service.IssueFilterService;
import com.shimi.gsf.core.model.Entity;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/filters"})
@CrossOrigin
@Tag(name="Issue filter", description="Issue filter Management")
@RolesAllowed(value={"ROLE_USER"})
public class IssueFilterController
extends BaseController {
    @Autowired
    private IssueFilterService filterService;

    @Operation(summary="Create a new issue filter")
    @PostMapping
    public IssueFilterDto create(@RequestBody IssueFilterDto filterDto) {
        IssueFilter filter = (IssueFilter)this.filterService.create((Entity)filterDto.toEntity());
        return filter.toDto();
    }

    @Operation(summary="Get an existing issue filter")
    @Parameters(value={@Parameter(name="id", description="Issue ID")})
    @GetMapping(value={"/{id}"})
    public IssueFilterDto get(@PathVariable Long id) {
        IssueFilter filter = (IssueFilter)this.filterService.get(id);
        return filter.toDto();
    }

    @Operation(summary="Update issue filter")
    @Parameters(value={@Parameter(name="id", description="Issue ID")})
    @PutMapping(value={"/{id}"})
    public IssueFilterDto update(@PathVariable Long id, @RequestBody IssueFilterDto filterDto) {
        IssueFilter filter = (IssueFilter)this.filterService.update(id, (Entity)filterDto.toEntity());
        return filter.toDto();
    }

    @Operation(summary="Delete an issue filter")
    @Parameters(value={@Parameter(name="id", description="Issue ID")})
    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable Long id) {
        this.filterService.delete(id);
    }

    @Operation(summary="Get all filters created by myself")
    @Parameters(value={@Parameter(name="projectId", description="Project ID")})
    @GetMapping(value={"/my"})
    public List<IssueFilterDto> getMyFilters(@RequestParam Long projectId) {
        List filters = this.filterService.findMyFilters(projectId);
        return filters.stream().map(IssueFilter::toDto).toList();
    }

    @Operation(summary="Copy an issue filter")
    @Parameters(value={@Parameter(name="id", description="Issue ID")})
    @PostMapping(value={"/{id}/copy"})
    public IssueFilterDto copy(@PathVariable Long id) {
        IssueFilter newFilter = this.filterService.copyFilter(id);
        return newFilter.toDto();
    }
}

