/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.issue.controller;

import com.shimi.gogoscrum.common.controller.BaseController;
import com.shimi.gogoscrum.issue.dto.IssueGroupDto;
import com.shimi.gogoscrum.issue.model.IssueGroup;
import com.shimi.gogoscrum.issue.service.IssueGroupService;
import com.shimi.gsf.core.model.Entity;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/issueGroups"})
@CrossOrigin
@Tag(name="Issue group", description="Issue group management")
@RolesAllowed(value={"ROLE_USER"})
public class IssueGroupController
extends BaseController {
    @Autowired
    private IssueGroupService issueGroupService;

    @Operation(summary="Create a new issue group")
    @PostMapping
    public IssueGroupDto create(@RequestBody IssueGroupDto issueGroupDto) {
        IssueGroup savedIssueGroup = (IssueGroup)this.issueGroupService.create((Entity)issueGroupDto.toEntity());
        return savedIssueGroup.toDto();
    }

    @Operation(summary="Update an issue group")
    @Parameters(value={@Parameter(name="id", description="Issue group ID")})
    @PostMapping(value={"/{id}"})
    public IssueGroupDto update(@PathVariable Long id, @RequestBody IssueGroupDto issueGroupDto) {
        IssueGroup savedIssueGroup = (IssueGroup)this.issueGroupService.update(id, (Entity)issueGroupDto.toEntity());
        return savedIssueGroup.toDto();
    }

    @Operation(summary="Delete an issue group")
    @Parameters(value={@Parameter(name="id", description="Issue group ID")})
    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable Long id) {
        this.issueGroupService.delete(id);
    }

    @Operation(summary="Update issue groups seq")
    @PostMapping(value={"/seq"})
    public void updateSeq(@RequestBody List<Long> issueGroupIds) {
        this.issueGroupService.updateSeq(issueGroupIds);
    }
}

