/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.issue.model;

import com.shimi.gogoscrum.common.model.BaseEntity;
import com.shimi.gogoscrum.issue.dto.CommentDto;
import com.shimi.gogoscrum.issue.model.Issue;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.text.SimpleDateFormat;
import org.springframework.beans.BeanUtils;

@Entity
public class Comment
extends BaseEntity {
    private static final long serialVersionUID = 2633981347091498423L;
    private String content;
    @ManyToOne
    @JoinColumn(name="issue_id")
    private Issue issue;

    public CommentDto toDto() {
        return this.toDto(false);
    }

    public CommentDto toDto(boolean detailed) {
        CommentDto dto = new CommentDto();
        BeanUtils.copyProperties((Object)this, (Object)dto);
        dto.setIssueId(this.issue.getId());
        dto.setCreatedBy(this.createdBy.toDto());
        return dto;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public void setIssue(Issue issue) {
        this.issue = issue;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String toString() {
        return "Comment{id=" + this.id + ", content='" + this.content + "'}";
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.createdTime));
        sb.append(" ").append(this.createdBy.getNickname()).append("]: ").append(this.content);
        return sb.toString();
    }
}

