/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.issue.model;

import com.shimi.gogoscrum.common.model.BaseEntity;
import com.shimi.gogoscrum.common.model.Priority;
import com.shimi.gogoscrum.component.model.Component;
import com.shimi.gogoscrum.file.dto.FileDto;
import com.shimi.gogoscrum.file.model.File;
import com.shimi.gogoscrum.history.model.Historical;
import com.shimi.gogoscrum.issue.dto.CommentDto;
import com.shimi.gogoscrum.issue.dto.IssueDto;
import com.shimi.gogoscrum.issue.model.Comment;
import com.shimi.gogoscrum.issue.model.IssueGroup;
import com.shimi.gogoscrum.issue.model.IssueGroupStatus;
import com.shimi.gogoscrum.issue.model.IssueType;
import com.shimi.gogoscrum.project.model.Project;
import com.shimi.gogoscrum.sprint.model.Sprint;
import com.shimi.gogoscrum.tag.dto.TagDto;
import com.shimi.gogoscrum.tag.model.Tag;
import com.shimi.gogoscrum.testing.model.TestCase;
import com.shimi.gogoscrum.testing.model.TestPlan;
import com.shimi.gogoscrum.user.model.User;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Entity
public class Issue
extends BaseEntity
implements Historical {
    private static final long serialVersionUID = 2633981347091498557L;
    private String name;
    private String code;
    private String description;
    @Enumerated(value=EnumType.STRING)
    private IssueType type;
    @Enumerated(value=EnumType.STRING)
    private Priority priority = Priority.NORMAL;
    private Integer seq = 0;
    private Float storyPoints;
    private Date completedTime;
    private Date dueTime;
    private Float estimatedHours;
    private Float actualHours;
    @ManyToOne
    @JoinColumn(name="component_id")
    @NotFound(action=NotFoundAction.IGNORE)
    private Component component;
    @ManyToOne
    @JoinColumn(name="project_id")
    private Project project;
    @ManyToOne
    @JoinColumn(name="sprint_id")
    @NotFound(action=NotFoundAction.IGNORE)
    private Sprint sprint;
    @ManyToOne
    @JoinColumn(name="issue_group_id")
    @NotFound(action=NotFoundAction.IGNORE)
    private IssueGroup issueGroup;
    @ManyToOne
    @JoinColumn(name="owner_id")
    @NotFound(action=NotFoundAction.IGNORE)
    private User owner;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="test_case_id")
    @NotFound(action=NotFoundAction.IGNORE)
    private TestCase testCase;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="test_plan_id")
    @NotFound(action=NotFoundAction.IGNORE)
    private TestPlan testPlan;
    @OneToMany(cascade={CascadeType.REMOVE}, mappedBy="issue", fetch=FetchType.LAZY)
    private List<Comment> comments = new ArrayList();
    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="issue_file", joinColumns={@JoinColumn(name="issue_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="file_id", referencedColumnName="id")})
    private List<File> files = new ArrayList();
    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="issue_link", joinColumns={@JoinColumn(name="issue_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="linked_issue_id", referencedColumnName="id")})
    private List<Issue> linkToIssues = new ArrayList();
    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="issue_link", joinColumns={@JoinColumn(name="linked_issue_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="issue_id", referencedColumnName="id")})
    private List<Issue> linkedByIssues = new ArrayList();
    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="issue_tag", joinColumns={@JoinColumn(name="issue_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="tag_id", referencedColumnName="id")})
    private List<Tag> tags = new ArrayList();

    public Issue() {
    }

    public Issue(Long id) {
        this.id = id;
    }

    public IssueDto toDto() {
        return this.toDto(false);
    }

    public IssueDto toDtoForList() {
        IssueDto dto = new IssueDto();
        BeanUtils.copyProperties((Object)this, (Object)dto, (String[])new String[]{"comments", "owner", "sprint", "files", "linkToIssues", "linkedByIssues", "tags"});
        if (this.project != null) {
            dto.setProjectCode(this.project.getCode());
            dto.setProjectId(this.project.getId());
        }
        if (this.component != null) {
            dto.setComponentName(this.component.getName());
            dto.setComponentId(this.component.getId());
        }
        if (this.owner != null) {
            dto.setOwner(this.owner.toDto());
        }
        if (this.sprint != null) {
            dto.setSprint(this.sprint.toDto());
        }
        if (this.issueGroup != null) {
            dto.setIssueGroup(this.issueGroup.toDto());
        }
        dto.setCommentsCount(this.comments.size());
        dto.setFilesCount(this.files.size());
        dto.setLinksCount(this.linkToIssues.size());
        dto.setLinkedCount(this.linkedByIssues.size());
        if (!CollectionUtils.isEmpty((Collection)this.tags)) {
            List<TagDto> tagDtos = this.tags.stream().map(Tag::toDto).toList();
            dto.setTags(tagDtos);
        }
        return dto;
    }

    public IssueDto toDto(boolean detailed) {
        IssueDto dto = this.toDtoForList();
        if (detailed) {
            if (this.createdBy != null) {
                dto.setCreatedBy(this.createdBy.toDto());
            }
            if (this.testCase != null) {
                dto.setTestCase(this.testCase.toDto());
            }
            if (this.testPlan != null) {
                dto.setTestPlan(this.testPlan.toDto());
            }
            if (!CollectionUtils.isEmpty((Collection)this.comments)) {
                List<CommentDto> commentDtos = this.comments.stream().map(Comment::toDto).toList();
                dto.setComments(commentDtos);
            }
            if (!CollectionUtils.isEmpty((Collection)this.files)) {
                List<FileDto> fileDtos = this.files.stream().map(File::toDto).toList();
                dto.setFiles(fileDtos);
            }
            if (!CollectionUtils.isEmpty((Collection)this.linkToIssues)) {
                List<IssueDto> linkToIssueDtos = this.linkToIssues.stream().map(Issue::toDto).toList();
                dto.setLinkToIssues(linkToIssueDtos);
            }
            if (!CollectionUtils.isEmpty((Collection)this.linkedByIssues)) {
                List<IssueDto> linkedByIssueDtos = this.linkedByIssues.stream().map(Issue::toDto).toList();
                dto.setLinkedByIssues(linkedByIssueDtos);
            }
            if (!CollectionUtils.isEmpty((Collection)this.tags)) {
                List<TagDto> tagDtos = this.tags.stream().map(Tag::toDto).toList();
                dto.setTags(tagDtos);
            }
        }
        return dto;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public IssueType getType() {
        return this.type;
    }

    public void setType(IssueType type) {
        this.type = type;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public Integer getSeq() {
        return this.seq;
    }

    public void setSeq(Integer seq) {
        this.seq = seq;
    }

    public Float getStoryPoints() {
        return this.storyPoints;
    }

    public void setStoryPoints(Float storyPoints) {
        this.storyPoints = storyPoints;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public Sprint getSprint() {
        return this.sprint;
    }

    public void setSprint(Sprint sprint) {
        this.sprint = sprint;
    }

    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User owner) {
        this.owner = owner;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public void setComments(List<Comment> commentList) {
        this.comments = commentList;
    }

    public Date getCompletedTime() {
        return this.completedTime;
    }

    public Date getDueTime() {
        return this.dueTime;
    }

    public void setDueTime(Date dueTime) {
        this.dueTime = dueTime;
    }

    public void setCompletedTime(Date completedTime) {
        this.completedTime = completedTime;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public IssueGroup getIssueGroup() {
        return this.issueGroup;
    }

    public void setIssueGroup(IssueGroup issueGroup) {
        this.issueGroup = issueGroup;
    }

    public List<Issue> getLinkToIssues() {
        return this.linkToIssues;
    }

    public void setLinkToIssues(List<Issue> linkToIssues) {
        this.linkToIssues = linkToIssues;
    }

    public List<Issue> getLinkedByIssues() {
        return this.linkedByIssues;
    }

    public void setLinkedByIssues(List<Issue> linkedByIssues) {
        this.linkedByIssues = linkedByIssues;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public boolean isDone() {
        return this.issueGroup != null && IssueGroupStatus.DONE.equals((Object)this.issueGroup.getStatus());
    }

    public Float getEstimatedHours() {
        return this.estimatedHours;
    }

    public void setEstimatedHours(Float estimatedHours) {
        this.estimatedHours = estimatedHours;
    }

    public Float getActualHours() {
        return this.actualHours;
    }

    public void setActualHours(Float actualHours) {
        this.actualHours = actualHours;
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public void setTestCase(TestCase testCase) {
        this.testCase = testCase;
    }

    public TestPlan getTestPlan() {
        return this.testPlan;
    }

    public void setTestPlan(TestPlan testPlan) {
        this.testPlan = testPlan;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Issue{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", code='").append(this.code).append('\'');
        sb.append(", type=").append(this.type);
        sb.append(", priority=").append(this.priority);
        sb.append(", seq=").append(this.seq);
        sb.append(", storyPoints=").append(this.storyPoints);
        sb.append(", completedTime=").append(this.completedTime);
        sb.append(", dueTime=").append(this.dueTime);
        sb.append('}');
        return sb.toString();
    }

    public String getDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append("name='").append(this.name).append('\'');
        if (StringUtils.hasText((String)this.description)) {
            sb.append(", desc='").append(this.description).append('\'');
        }
        sb.append(", type=").append(this.type);
        sb.append(", priority=").append(this.priority);
        if (this.owner != null) {
            sb.append(", owner='").append(this.owner.getNickname()).append('\'');
        }
        if (this.issueGroup != null) {
            sb.append(", issueGroup='").append(this.issueGroup.getLabel()).append('\'');
        }
        if (this.sprint != null) {
            sb.append(", sprint='").append(this.sprint.getName()).append('\'');
        }
        if (this.storyPoints != null) {
            sb.append(", storyPoint=").append(this.storyPoints);
        }
        if (this.estimatedHours != null) {
            sb.append(", estimatedHours=").append(this.estimatedHours);
        }
        if (this.actualHours != null) {
            sb.append(", actualHours=").append(this.actualHours);
        }
        if (this.component != null) {
            sb.append(", component='").append(this.component.getName()).append('\'');
        }
        if (this.dueTime != null) {
            sb.append(", dueTime=").append(this.dueTime);
        }
        return sb.toString();
    }
}

