/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.issue.model;

import com.shimi.gogoscrum.common.model.BaseEntity;
import com.shimi.gogoscrum.common.model.Priority;
import com.shimi.gogoscrum.common.util.ListOfLongToStringConverter;
import com.shimi.gogoscrum.common.util.ListOfOrderToStringConverter;
import com.shimi.gogoscrum.common.util.ListOfPriorityToStringConverter;
import com.shimi.gogoscrum.issue.dto.IssueFilterDto;
import com.shimi.gogoscrum.issue.model.IssueType;
import com.shimi.gogoscrum.issue.util.ListOfIssueTypeToStringConverter;
import com.shimi.gsf.core.model.Filter;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;

@Entity
public class IssueFilter
extends BaseEntity
implements Filter {
    private static final long serialVersionUID = 2806131752606175926L;
    private String name;
    private Long projectId;
    private String keyword;
    private int seq;
    @Convert(converter=ListOfLongToStringConverter.class)
    private List<Long> sprintIds;
    @Convert(converter=ListOfLongToStringConverter.class)
    private List<Long> groupIds;
    @Convert(converter=ListOfLongToStringConverter.class)
    private List<Long> componentIds;
    @Convert(converter=ListOfIssueTypeToStringConverter.class)
    private List<IssueType> types;
    @Convert(converter=ListOfPriorityToStringConverter.class)
    private List<Priority> priorities;
    @Convert(converter=ListOfLongToStringConverter.class)
    private List<Long> tagIds;
    @Convert(converter=ListOfLongToStringConverter.class)
    private List<Long> ownerIds;
    @Convert(converter=ListOfOrderToStringConverter.class)
    private List<Filter.Order> orders = new ArrayList();
    @Transient
    private int page = 1;
    @Transient
    private int pageSize = 10;
    @Transient
    private Boolean backlog;
    @Transient
    private String language;
    @Transient
    private Long testCaseId;
    @Transient
    private Long testPlanId;

    public IssueFilterDto toDto() {
        IssueFilterDto dto = new IssueFilterDto();
        BeanUtils.copyProperties((Object)this, (Object)dto);
        if (this.createdBy != null) {
            dto.setCreatedBy(this.createdBy.toDto().normalize());
        }
        return dto;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public List<Long> getSprintIds() {
        return this.sprintIds;
    }

    public void setSprintIds(List<Long> sprintIds) {
        this.sprintIds = sprintIds;
    }

    public List<Long> getGroupIds() {
        return this.groupIds;
    }

    public void setGroupIds(List<Long> groupIds) {
        this.groupIds = groupIds;
    }

    public List<Long> getComponentIds() {
        return this.componentIds;
    }

    public void setComponentIds(List<Long> componentIds) {
        this.componentIds = componentIds;
    }

    public List<IssueType> getTypes() {
        return this.types;
    }

    public void setTypes(List<IssueType> types) {
        this.types = types;
    }

    public List<Priority> getPriorities() {
        return this.priorities;
    }

    public void setPriorities(List<Priority> priorities) {
        this.priorities = priorities;
    }

    public List<Long> getTagIds() {
        return this.tagIds;
    }

    public void setTagIds(List<Long> tagIds) {
        this.tagIds = tagIds;
    }

    public List<Long> getOwnerIds() {
        return this.ownerIds;
    }

    public void setOwnerIds(List<Long> ownerIds) {
        this.ownerIds = ownerIds;
    }

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public int getPage() {
        return this.page > 1 ? this.page - 1 : 0;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public List<Filter.Order> getOrders() {
        return this.orders;
    }

    public void setOrders(List<Filter.Order> orders) {
        this.orders = orders;
    }

    public Boolean getBacklog() {
        return this.backlog;
    }

    public void setBacklog(Boolean backlog) {
        this.backlog = backlog;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public Long getTestCaseId() {
        return this.testCaseId;
    }

    public void setTestCaseId(Long testCaseId) {
        this.testCaseId = testCaseId;
    }

    public Long getTestPlanId() {
        return this.testPlanId;
    }

    public void setTestPlanId(Long testPlanId) {
        this.testPlanId = testPlanId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IssueFilter{");
        sb.append("projectId=").append(this.projectId);
        sb.append(", keyword='").append(this.keyword).append('\'');
        sb.append(", sprintIds=").append(this.sprintIds);
        sb.append(", groupIds=").append(this.groupIds);
        sb.append(", componentIds=").append(this.componentIds);
        sb.append(", types=").append(this.types);
        sb.append(", priorities=").append(this.priorities);
        sb.append(", tagIds=").append(this.tagIds);
        sb.append(", ownerIds=").append(this.ownerIds);
        sb.append(", page=").append(this.page);
        sb.append(", pageSize=").append(this.pageSize);
        sb.append(", id=").append(this.id);
        sb.append('}');
        return sb.toString();
    }
}

