/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.issue.model;

import com.shimi.gogoscrum.common.model.BaseEntity;
import com.shimi.gogoscrum.issue.dto.IssueGroupDto;
import com.shimi.gogoscrum.issue.model.IssueGroupStatus;
import com.shimi.gogoscrum.project.model.Project;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import org.springframework.beans.BeanUtils;

@Entity
public class IssueGroup
extends BaseEntity {
    private static final long serialVersionUID = 6234533279589155880L;
    private String label;
    private boolean builtIn;
    private short seq;
    @Enumerated(value=EnumType.STRING)
    private IssueGroupStatus status;
    @ManyToOne
    @JoinColumn(name="project_id")
    private Project project;

    public IssueGroupDto toDto() {
        return this.toDto(false);
    }

    public IssueGroupDto toDto(boolean detail) {
        IssueGroupDto dto = new IssueGroupDto();
        BeanUtils.copyProperties((Object)this, (Object)dto, (String[])new String[]{"project"});
        if (detail && this.project != null) {
            dto.setProject(this.project.toDto());
        }
        return dto;
    }

    public IssueGroup() {
    }

    public IssueGroup(Long id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public short getSeq() {
        return this.seq;
    }

    public void setSeq(short seq) {
        this.seq = seq;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public void setBuiltIn(boolean builtIn) {
        this.builtIn = builtIn;
    }

    public IssueGroupStatus getStatus() {
        return this.status;
    }

    public void setStatus(IssueGroupStatus status) {
        this.status = status;
    }

    public String toString() {
        return "IssueGroup{id=" + this.id + ", label='" + this.label + "', status=" + String.valueOf(this.status) + "}";
    }
}

