/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.issue.repository;

import com.shimi.gogoscrum.issue.dto.IssueCountDto;
import com.shimi.gogoscrum.issue.model.Issue;
import com.shimi.gsf.core.repository.GeneralRepository;
import java.util.List;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

public interface IssueRepository
extends GeneralRepository<Issue> {
    @Query(value="select max(seq) from Issue i where (i.issueGroup.id = :groupId and i.sprint.id = :sprintId)")
    public Integer getLastSeq(Long var1, Long var2);

    public List<Issue> findBySprintId(Long var1);

    @Query(value="select new com.shimi.gogoscrum.issue.dto.IssueCountDto(i.issueGroup.id, count(i.id), sum(i.storyPoints))  from Issue i where i.sprint.id = :sprintId group by i.issueGroup")
    public List<IssueCountDto> countIssueByStatus(Long var1);

    @Modifying
    @Query(value="insert into issue_file (issue_id, file_id) values (:issueId, :fileId)", nativeQuery=true)
    public void addIssueFileLink(Long var1, Long var2);
}

