/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.issue.repository;

import com.shimi.gogoscrum.common.model.Priority;
import com.shimi.gogoscrum.issue.model.Issue;
import com.shimi.gogoscrum.issue.model.IssueType;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import java.io.Serializable;
import java.util.List;
import org.springframework.data.jpa.domain.Specification;

public class IssueSpecs {
    private IssueSpecs() {
        throw new IllegalStateException("Utility class");
    }

    public static Specification<Issue> nameLike(String keyword) {
        return (Specification & Serializable)(issue, criteriaQuery, criteriaBuilder) -> criteriaBuilder.like((Expression)issue.get("name"), "%" + keyword + "%");
    }

    public static Specification<Issue> typeIn(List<IssueType> types) {
        return (Specification & Serializable)(issue, criteriaQuery, criteriaBuilder) -> criteriaBuilder.in((Expression)issue.get("type")).value((Object)types);
    }

    public static Specification<Issue> priorityIn(List<Priority> priorities) {
        return (Specification & Serializable)(issue, criteriaQuery, criteriaBuilder) -> criteriaBuilder.in((Expression)issue.get("priority")).value((Object)priorities);
    }

    public static Specification<Issue> projectIdEquals(Long projectId) {
        return (Specification & Serializable)(issue, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)issue.get("project").get("id"), (Object)projectId);
    }

    public static Specification<Issue> sprintIdIn(List<Long> sprintIds) {
        return (Specification & Serializable)(issue, criteriaQuery, criteriaBuilder) -> criteriaBuilder.in((Expression)issue.get("sprint").get("id")).value((Object)sprintIds);
    }

    public static Specification<Issue> groupIdIn(List<Long> groupIds) {
        return (Specification & Serializable)(issue, criteriaQuery, criteriaBuilder) -> criteriaBuilder.in((Expression)issue.get("issueGroup").get("id")).value((Object)groupIds);
    }

    public static Specification<Issue> componentIdIn(List<Long> componentIds) {
        return (Specification & Serializable)(issue, criteriaQuery, criteriaBuilder) -> criteriaBuilder.in((Expression)issue.get("component").get("id")).value((Object)componentIds);
    }

    public static Specification<Issue> ownerIdIn(List<Long> ownerIds) {
        return (Specification & Serializable)(issue, criteriaQuery, criteriaBuilder) -> criteriaBuilder.in((Expression)issue.get("owner").get("id")).value((Object)ownerIds);
    }

    public static Specification<Issue> tagIdIn(List<Long> tagIds) {
        return (Specification & Serializable)(issue, criteriaQuery, criteriaBuilder) -> {
            Join join = issue.join("tags", JoinType.INNER);
            return criteriaBuilder.in((Expression)join.get("id")).value((Object)tagIds);
        };
    }

    public static Specification<Issue> codeLike(String keyword) {
        return (Specification & Serializable)(issue, criteriaQuery, criteriaBuilder) -> {
            Path projectCodePath = issue.get("sprint").get("project").get("code");
            Expression issueCodeExpression = criteriaBuilder.concat(criteriaBuilder.concat((Expression)projectCodePath, "-"), (Expression)issue.get("code"));
            return criteriaBuilder.like(issueCodeExpression, "%" + keyword + "%");
        };
    }

    public static Specification<Issue> inBacklog() {
        return (Specification & Serializable)(issue, criteriaQuery, criteriaBuilder) -> criteriaBuilder.isTrue((Expression)issue.get("sprint").get("backlog"));
    }

    public static Specification<Issue> testCaseIdEquals(Long testCaseId) {
        return (Specification & Serializable)(issue, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)issue.get("testCase").get("id"), (Object)testCaseId);
    }

    public static Specification<Issue> testPlanIdEquals(Long testPlanId) {
        return (Specification & Serializable)(issue, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)issue.get("testPlan").get("id"), (Object)testPlanId);
    }
}

