/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.issue.service;

import com.shimi.gogoscrum.common.service.BaseServiceImpl;
import com.shimi.gogoscrum.issue.model.Comment;
import com.shimi.gogoscrum.issue.model.CommentFilter;
import com.shimi.gogoscrum.issue.model.Issue;
import com.shimi.gogoscrum.issue.repository.CommentRepository;
import com.shimi.gogoscrum.issue.service.CommentService;
import com.shimi.gogoscrum.issue.service.IssueService;
import com.shimi.gogoscrum.project.model.Project;
import com.shimi.gogoscrum.project.service.ProjectService;
import com.shimi.gogoscrum.project.utils.ProjectMemberUtils;
import com.shimi.gogoscrum.user.model.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class CommentServiceImpl
extends BaseServiceImpl<Comment, CommentFilter>
implements CommentService {
    public static final Logger log = LoggerFactory.getLogger(CommentServiceImpl.class);
    @Autowired
    private CommentRepository repository;
    @Autowired
    private IssueService issueService;
    @Autowired
    private ProjectService projectService;

    protected CommentRepository getRepository() {
        return this.repository;
    }

    public Comment get(Long id) {
        Comment comment = (Comment)super.get(id);
        ProjectMemberUtils.checkMember((Project)((Project)this.projectService.get(comment.getIssue().getProject().getId())), (User)this.getCurrentUser());
        return comment;
    }

    protected void beforeCreate(Comment comment) {
        Issue issue = (Issue)this.issueService.get(comment.getIssue().getId());
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(issue.getProject().getId())), (User)this.getCurrentUser());
    }

    protected void beforeUpdate(Long id, Comment existingEntity, Comment newEntity) {
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(existingEntity.getIssue().getProject().getId())), (User)this.getCurrentUser());
    }

    protected void beforeDelete(Comment comment) {
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(comment.getIssue().getProject().getId())), (User)this.getCurrentUser());
    }

    protected Specification<Comment> toSpec(CommentFilter filter) {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

