/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.issue.service;

import com.shimi.gogoscrum.common.model.BaseEntity;
import com.shimi.gogoscrum.common.service.BaseServiceImpl;
import com.shimi.gogoscrum.common.util.PermissionUtil;
import com.shimi.gogoscrum.issue.model.IssueFilter;
import com.shimi.gogoscrum.issue.model.IssueFilterFilter;
import com.shimi.gogoscrum.issue.repository.IssueFilterRepository;
import com.shimi.gogoscrum.issue.service.IssueFilterService;
import com.shimi.gogoscrum.user.model.User;
import com.shimi.gsf.core.model.Entity;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class IssueFilterServiceImpl
extends BaseServiceImpl<IssueFilter, IssueFilterFilter>
implements IssueFilterService {
    public static final Logger log = LoggerFactory.getLogger(IssueFilterServiceImpl.class);
    @Autowired
    private IssueFilterRepository repository;

    protected IssueFilterRepository getRepository() {
        return this.repository;
    }

    public List<IssueFilter> findMyFilters(Long projectId) {
        return this.repository.findByProjectIdAndCreatedByIdOrderBySeq(projectId, this.getCurrentUser().getId());
    }

    protected void beforeDelete(IssueFilter filter) {
        PermissionUtil.checkOwnership((BaseEntity)filter, (User)this.getCurrentUser());
    }

    protected Specification<IssueFilter> toSpec(IssueFilterFilter filter) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public IssueFilter copyFilter(Long id) {
        IssueFilter existingFilter = (IssueFilter)this.get(id);
        IssueFilter newFilter = new IssueFilter();
        BeanUtils.copyProperties((Object)existingFilter, (Object)newFilter);
        newFilter.setName("Copy of " + existingFilter.getName());
        return (IssueFilter)super.create((Entity)newFilter);
    }

    public void updateSeq(List<Long> filterIds) {
        List newFilters = IntStream.range(0, filterIds.size()).mapToObj(i -> {
            IssueFilter filter = (IssueFilter)this.get((Long)filterIds.get(i));
            filter.setSeq(i);
            return filter;
        }).collect(Collectors.toList());
        this.repository.saveAll(newFilters);
        log.info("Issue filter seq updated with IDs : {}", filterIds);
    }
}

