/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.issue.service;

import com.shimi.gogoscrum.common.service.BaseServiceImpl;
import com.shimi.gogoscrum.issue.event.GroupSeqUpdatedEvent;
import com.shimi.gogoscrum.issue.model.IssueFilter;
import com.shimi.gogoscrum.issue.model.IssueGroup;
import com.shimi.gogoscrum.issue.model.IssueGroupFilter;
import com.shimi.gogoscrum.issue.repository.IssueGroupRepository;
import com.shimi.gogoscrum.issue.service.IssueGroupService;
import com.shimi.gogoscrum.issue.service.IssueService;
import com.shimi.gogoscrum.project.model.Project;
import com.shimi.gogoscrum.project.service.ProjectService;
import com.shimi.gogoscrum.project.utils.ProjectMemberUtils;
import com.shimi.gogoscrum.user.model.User;
import com.shimi.gsf.core.exception.BaseServiceException;
import com.shimi.gsf.core.exception.EntityDuplicatedException;
import com.shimi.gsf.core.model.EntityQueryResult;
import com.shimi.gsf.core.model.Filter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IssueGroupServiceImpl
extends BaseServiceImpl<IssueGroup, IssueGroupFilter>
implements IssueGroupService {
    public static final Logger log = LoggerFactory.getLogger(IssueGroupServiceImpl.class);
    @Autowired
    private IssueGroupRepository repository;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private IssueService issueService;

    protected IssueGroupRepository getRepository() {
        return this.repository;
    }

    public IssueGroup get(Long id) {
        IssueGroup issueGroup = (IssueGroup)super.get(id);
        ProjectMemberUtils.checkMember((Project)((Project)this.projectService.get(issueGroup.getProject().getId())), (User)this.getCurrentUser());
        return issueGroup;
    }

    public void updateSeq(List<Long> issueGroupIds) {
        List newIssueGroups = IntStream.range(0, issueGroupIds.size()).mapToObj(i -> {
            IssueGroup issueGroup = this.get((Long)issueGroupIds.get(i));
            issueGroup.setSeq((short)i);
            return issueGroup;
        }).collect(Collectors.toList());
        User currentUser = this.getCurrentUser();
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(((IssueGroup)newIssueGroups.getFirst()).getProject().getId())), (User)currentUser);
        this.repository.saveAll(newIssueGroups);
        log.info("IssueGroup seq updated in IDs\uff1a {}", issueGroupIds);
        CollectionUtils.isEmpty(newIssueGroups);
        IssueGroup group = (IssueGroup)newIssueGroups.getFirst();
        this.eventPublisher.publishEvent((ApplicationEvent)new GroupSeqUpdatedEvent((Object)group.getProject(), group.getProject().getId(), currentUser));
    }

    protected String[] getUpdateIgnoredProps() {
        return new String[]{"id", "createdTime", "createdBy", "project", "builtIn", "status"};
    }

    protected void beforeCreate(IssueGroup issueGroup) {
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(issueGroup.getProject().getId())), (User)this.getCurrentUser());
        this.checkDuplicatedGroupLabel(issueGroup, issueGroup.getProject().getId());
    }

    protected void beforeUpdate(Long id, IssueGroup existingEntity, IssueGroup newEntity) {
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(existingEntity.getProject().getId())), (User)this.getCurrentUser());
        this.checkDuplicatedGroupLabel(newEntity, existingEntity.getProject().getId());
    }

    private void checkDuplicatedGroupLabel(IssueGroup issueGroup, Long projectId) {
        IssueGroup existingGroup = this.repository.getByProjectIdAndLabelEquals(projectId, issueGroup.getLabel());
        if (existingGroup != null && !existingGroup.getId().equals(issueGroup.getId())) {
            throw new EntityDuplicatedException("duplicatedGroup", "Duplicated group label already exists");
        }
    }

    protected void beforeDelete(IssueGroup issueGroup) {
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(issueGroup.getProject().getId())), (User)this.getCurrentUser());
        if (issueGroup.isBuiltIn()) {
            throw new BaseServiceException("cannotDelete", "This issue group is built-in and cannot be deleted", HttpStatus.NOT_ACCEPTABLE);
        }
        this.moveIssuesIntoTodo(issueGroup);
    }

    private void moveIssuesIntoTodo(IssueGroup deletingGroup) {
        IssueFilter filter = new IssueFilter();
        filter.setPageSize(Integer.MAX_VALUE);
        filter.setGroupIds(Collections.singletonList(deletingGroup.getId()));
        EntityQueryResult queryResult = this.issueService.search((Filter)filter);
        List issues = queryResult.getResults();
        IssueGroup toDoIssueGroup = deletingGroup.getProject().getToDoIssueGroup();
        if (toDoIssueGroup != null && !CollectionUtils.isEmpty((Collection)issues)) {
            issues.forEach(issue -> {
                issue.setIssueGroup(toDoIssueGroup);
                issue.setSeq(Integer.valueOf(999));
            });
            this.issueService.saveAll(issues);
            log.info("{} issues moved from group {} (id = {}) into todo status (id = {})", new Object[]{issues.size(), deletingGroup.getLabel(), deletingGroup.getId(), toDoIssueGroup.getId()});
        }
    }

    protected Specification<IssueGroup> toSpec(IssueGroupFilter filter) {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

