/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.issue.service;

import com.shimi.gogoscrum.common.service.BaseServiceImpl;
import com.shimi.gogoscrum.common.util.Exporter;
import com.shimi.gogoscrum.component.model.Component;
import com.shimi.gogoscrum.component.service.ComponentService;
import com.shimi.gogoscrum.file.model.File;
import com.shimi.gogoscrum.file.model.TargetType;
import com.shimi.gogoscrum.file.service.FileService;
import com.shimi.gogoscrum.issue.dto.IssueCountDto;
import com.shimi.gogoscrum.issue.event.IssueSeqUpdatedEvent;
import com.shimi.gogoscrum.issue.model.Comment;
import com.shimi.gogoscrum.issue.model.Issue;
import com.shimi.gogoscrum.issue.model.IssueFilter;
import com.shimi.gogoscrum.issue.model.IssueGroup;
import com.shimi.gogoscrum.issue.model.IssueGroupStatus;
import com.shimi.gogoscrum.issue.repository.IssueRepository;
import com.shimi.gogoscrum.issue.repository.IssueSpecs;
import com.shimi.gogoscrum.issue.service.IssueGroupService;
import com.shimi.gogoscrum.issue.service.IssueService;
import com.shimi.gogoscrum.project.model.Project;
import com.shimi.gogoscrum.project.service.ProjectService;
import com.shimi.gogoscrum.project.utils.ProjectMemberUtils;
import com.shimi.gogoscrum.sprint.model.Sprint;
import com.shimi.gogoscrum.sprint.service.SprintService;
import com.shimi.gogoscrum.tag.model.Tag;
import com.shimi.gogoscrum.user.service.UserService;
import com.shimi.gsf.core.event.EntityChangeEvent;
import com.shimi.gsf.core.exception.BadRequestException;
import com.shimi.gsf.core.model.Entity;
import com.shimi.gsf.core.model.EntityQueryResult;
import com.shimi.gsf.core.model.Filter;
import com.shimi.gsf.core.model.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.EventListener;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class IssueServiceImpl
extends BaseServiceImpl<Issue, IssueFilter>
implements IssueService {
    public static final Logger log = LoggerFactory.getLogger(IssueServiceImpl.class);
    @Autowired
    private IssueRepository repository;
    @Autowired
    private UserService userService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private ComponentService componentService;
    @Autowired
    private SprintService sprintService;
    @Autowired
    private IssueGroupService groupService;
    @Autowired
    private FileService fileService;

    protected IssueRepository getRepository() {
        return this.repository;
    }

    public Issue get(Long id) {
        Issue issue = (Issue)super.get(id);
        ProjectMemberUtils.checkMember((Project)((Project)this.projectService.get(issue.getProject().getId())), (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        return issue;
    }

    protected void beforeCreate(Issue issue) {
        Project project = (Project)this.projectService.get(issue.getProject().getId());
        ProjectMemberUtils.checkDeveloper((Project)project, (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        issue.setProject(project);
        issue.setCode(this.generateIssueCode(project.getId()));
        com.shimi.gogoscrum.user.model.User currentUser = this.getCurrentUser();
        if (issue.getSprint() == null) {
            issue.setSprint(project.getBacklogSprint());
        }
        if (issue.getIssueGroup() == null) {
            issue.setIssueGroup(project.getToDoIssueGroup());
        }
        if (issue.getIssueGroup().getStatus().equals((Object)IssueGroupStatus.DONE)) {
            issue.setCompletedTime(new Date());
        }
        if (!CollectionUtils.isEmpty((Collection)issue.getFiles())) {
            issue.getFiles().forEach(file -> file.setAllTraceInfo((User)currentUser));
        }
        if (issue.getComponent() != null && issue.getComponent().getId() != null && issue.getComponent().getName() == null) {
            issue.setComponent((Component)this.componentService.get(issue.getComponent().getId()));
        }
    }

    private synchronized String generateIssueCode(Long projectId) {
        return this.projectService.generateNextIssueCode(projectId);
    }

    protected void afterCreate(Issue issue) {
        this.sprintService.refreshSprintIssueCount(issue.getSprint().getId());
    }

    protected void beforeUpdate(Long id, Issue existingIssue, Issue newIssue) {
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(existingIssue.getProject().getId())), (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        if (newIssue.getSprint() == null) {
            newIssue.setSprint(existingIssue.getProject().getBacklogSprint());
        }
        if (newIssue.getIssueGroup().getStatus().equals((Object)IssueGroupStatus.DONE)) {
            if (!existingIssue.getIssueGroup().getStatus().equals((Object)newIssue.getIssueGroup().getStatus())) {
                newIssue.setCompletedTime(new Date());
            }
        } else {
            newIssue.setCompletedTime(null);
        }
        com.shimi.gogoscrum.user.model.User currentUser = this.getCurrentUser();
        if (!CollectionUtils.isEmpty((Collection)newIssue.getFiles())) {
            newIssue.getFiles().forEach(file -> {
                if (file.getCreatedBy() == null) {
                    file.setAllTraceInfo((User)currentUser);
                }
            });
        }
        if (newIssue.getOwner() != null && newIssue.getOwner().getId() != null) {
            newIssue.setOwner((com.shimi.gogoscrum.user.model.User)this.userService.get(newIssue.getOwner().getId()));
        }
    }

    protected void afterUpdate(Long id, Issue oldIssue, Issue newIssue) {
        if (!Objects.equals(oldIssue.getSprint().getId(), newIssue.getSprint().getId()) || !Objects.equals(oldIssue.getIssueGroup().getId(), newIssue.getIssueGroup().getId())) {
            this.sprintService.refreshSprintIssueCount(oldIssue.getSprint().getId());
            this.sprintService.refreshSprintIssueCount(newIssue.getSprint().getId());
        }
    }

    protected String[] getUpdateIgnoredProps() {
        return new String[]{"id", "code", "project", "createdTime", "createdBy", "linkToIssues", "linkedByIssues", "comments", "files"};
    }

    public void updateIssuesSeq(List<Long> issueIds) {
        List newIssues = IntStream.range(0, issueIds.size()).mapToObj(i -> {
            Issue issue = this.get((Long)issueIds.get(i));
            issue.setSeq(Integer.valueOf(i));
            return issue;
        }).collect(Collectors.toList());
        com.shimi.gogoscrum.user.model.User currentUser = this.getCurrentUser();
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(((Issue)newIssues.getFirst()).getProject().getId())), (com.shimi.gogoscrum.user.model.User)currentUser);
        this.repository.saveAll(newIssues);
        log.info("Issue seq updated with IDs in : {}", issueIds);
        if (!CollectionUtils.isEmpty(newIssues)) {
            Issue issue = (Issue)newIssues.getFirst();
            this.eventPublisher.publishEvent((ApplicationEvent)new IssueSeqUpdatedEvent((Object)issue.getIssueGroup(), issue.getSprint().getId(), currentUser));
        }
    }

    public Issue moveIssueToGroup(Long issueId, Long groupId) {
        Issue issue = this.get(issueId);
        Issue newIssue = new Issue();
        BeanUtils.copyProperties((Object)issue, (Object)newIssue);
        if (issue.getIssueGroup() == null || !issue.getIssueGroup().getId().equals(groupId)) {
            IssueGroup issueGroup = (IssueGroup)this.groupService.get(groupId);
            newIssue.setIssueGroup(issueGroup);
            return (Issue)super.update(issueId, (Entity)newIssue);
        }
        return issue;
    }

    private Issue moveIssueToSprint(Long issueId, Long sprintId) {
        Issue issue = this.get(issueId);
        Issue newIssue = new Issue();
        BeanUtils.copyProperties((Object)issue, (Object)newIssue);
        if (issue.getSprint() == null || !issue.getSprint().getId().equals(sprintId)) {
            Sprint sprint = (Sprint)this.sprintService.get(sprintId);
            newIssue.setSprint(sprint);
            return (Issue)super.update(issueId, (Entity)newIssue);
        }
        return issue;
    }

    public File addFile(Long issueId, File file) {
        Issue issue = this.get(issueId);
        Project project = (Project)this.projectService.get(issue.getProject().getId());
        Long projectId = project.getId();
        ProjectMemberUtils.checkDeveloper((Project)project, (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        file.setProjectId(projectId);
        file.setTargetType(TargetType.ISSUE_ATTACHMENT);
        File savedFile = (File)this.fileService.create((Entity)file);
        this.repository.addIssueFileLink(issueId, savedFile.getId());
        log.info("File {} added to issue {}", (Object)savedFile.getId(), (Object)issueId);
        return savedFile;
    }

    public void deleteFile(Long issueId, Long fileId) {
        Issue issue = this.get(issueId);
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(issue.getProject().getId())), (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        issue.getFiles().stream().filter(f -> f.getId().equals(fileId)).findFirst().orElseThrow(() -> new BadRequestException("File " + fileId + " does not belong to issue " + issueId));
        this.fileService.delete(fileId);
        List updatedFiles = issue.getFiles().stream().filter(f -> !f.getId().equals(fileId)).collect(Collectors.toList());
        issue.setFiles(updatedFiles);
        this.repository.save((Object)issue);
        log.info("File {} deleted from issue {}", (Object)fileId, (Object)issueId);
    }

    public Issue assignTo(Long issueId, Long userId) {
        Issue issue = this.get(issueId);
        if (issue.getOwner() == null || !issue.getOwner().getId().equals(userId)) {
            com.shimi.gogoscrum.user.model.User user = (com.shimi.gogoscrum.user.model.User)this.userService.get(userId);
            issue.setOwner(user);
            return this.update(issueId, issue);
        }
        return issue;
    }

    public Issue unassign(Long issueId) {
        Issue issue = this.get(issueId);
        if (issue.getOwner() != null) {
            issue.setOwner(null);
            return this.update(issueId, issue);
        }
        return issue;
    }

    public void linkIssue(Long issueId, Long linkToIssueId) {
        Issue issue = this.get(issueId);
        issue.getLinkToIssues().add(this.get(linkToIssueId));
        this.repository.save((Object)issue);
        log.info("Issue with ID {} linked with issue with ID {}", (Object)issueId, (Object)linkToIssueId);
    }

    public void unlinkIssue(Long issueId, Long linkToIssueId) {
        Issue issue = this.get(issueId);
        List currentLinkTos = issue.getLinkToIssues();
        List updatedLinkTos = currentLinkTos.stream().filter(linkIssue -> !linkIssue.getId().equals(linkToIssueId)).collect(Collectors.toList());
        issue.setLinkToIssues(updatedLinkTos);
        List currentLinkedBys = issue.getLinkedByIssues();
        List updatedLinkedBys = currentLinkedBys.stream().filter(linkIssue -> !linkIssue.getId().equals(linkToIssueId)).collect(Collectors.toList());
        issue.setLinkedByIssues(updatedLinkedBys);
        this.repository.save((Object)issue);
        log.info("Issue with ID {} unlinked with issue with ID {}", (Object)issueId, (Object)linkToIssueId);
    }

    public EntityQueryResult<Issue> search(IssueFilter filter) {
        Long projectId = filter.getProjectId();
        if (projectId == null) {
            throw new BadRequestException("Project ID is required for issue search.");
        }
        ProjectMemberUtils.checkMember((Project)((Project)this.projectService.get(projectId)), (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        return super.search((Filter)filter);
    }

    protected Specification<Issue> toSpec(IssueFilter filter) {
        Specification querySpec = null;
        if (filter.getProjectId() == null) {
            throw new BadRequestException("Project ID is required for issue search.");
        }
        querySpec = IssueSpecs.projectIdEquals((Long)filter.getProjectId());
        if (!CollectionUtils.isEmpty((Collection)filter.getTypes())) {
            Specification typeIn = IssueSpecs.typeIn((List)filter.getTypes());
            Specification specification = querySpec = Objects.isNull(querySpec) ? typeIn : querySpec.and(typeIn);
        }
        if (!CollectionUtils.isEmpty((Collection)filter.getPriorities())) {
            Specification priorityIn = IssueSpecs.priorityIn((List)filter.getPriorities());
            Specification specification = querySpec = Objects.isNull(querySpec) ? priorityIn : querySpec.and(priorityIn);
        }
        if (Boolean.TRUE.equals(filter.getBacklog())) {
            Specification inBacklog = IssueSpecs.inBacklog();
            Specification specification = querySpec = Objects.isNull(querySpec) ? inBacklog : querySpec.and(inBacklog);
        }
        if (!CollectionUtils.isEmpty((Collection)filter.getSprintIds())) {
            Specification sprintIdIn = IssueSpecs.sprintIdIn((List)filter.getSprintIds());
            Specification specification = querySpec = Objects.isNull(querySpec) ? sprintIdIn : querySpec.and(sprintIdIn);
        }
        if (!CollectionUtils.isEmpty((Collection)filter.getGroupIds())) {
            Specification groupIdIn = IssueSpecs.groupIdIn((List)filter.getGroupIds());
            Specification specification = querySpec = Objects.isNull(querySpec) ? groupIdIn : querySpec.and(groupIdIn);
        }
        if (!CollectionUtils.isEmpty((Collection)filter.getComponentIds())) {
            Specification componentIdIn = IssueSpecs.componentIdIn((List)filter.getComponentIds());
            Specification specification = querySpec = Objects.isNull(querySpec) ? componentIdIn : querySpec.and(componentIdIn);
        }
        if (!CollectionUtils.isEmpty((Collection)filter.getOwnerIds())) {
            Specification ownerIdIn = IssueSpecs.ownerIdIn((List)filter.getOwnerIds());
            Specification specification = querySpec = Objects.isNull(querySpec) ? ownerIdIn : querySpec.and(ownerIdIn);
        }
        if (!CollectionUtils.isEmpty((Collection)filter.getTagIds())) {
            Specification tagIdIn = IssueSpecs.tagIdIn((List)filter.getTagIds());
            Specification specification = querySpec = Objects.isNull(querySpec) ? tagIdIn : querySpec.and(tagIdIn);
        }
        if (StringUtils.hasText((String)filter.getKeyword())) {
            String keyword = filter.getKeyword();
            Specification codeOrNameLike = IssueSpecs.codeLike((String)keyword).or(IssueSpecs.nameLike((String)keyword));
            Specification specification = querySpec = Objects.isNull(querySpec) ? codeOrNameLike : querySpec.and(codeOrNameLike);
        }
        if (filter.getTestCaseId() != null) {
            Specification testCaseIdEquals = IssueSpecs.testCaseIdEquals((Long)filter.getTestCaseId());
            Specification specification = querySpec = Objects.isNull(querySpec) ? testCaseIdEquals : querySpec.and(testCaseIdEquals);
        }
        if (filter.getTestPlanId() != null) {
            Specification testPlanIdEquals = IssueSpecs.testPlanIdEquals((Long)filter.getTestPlanId());
            querySpec = Objects.isNull(querySpec) ? testPlanIdEquals : querySpec.and(testPlanIdEquals);
        }
        return querySpec;
    }

    public Issue update(Long id, Issue issue) {
        Issue exitingIssue = this.get(id);
        if (!(exitingIssue.getIssueGroup() == null || exitingIssue.getSprint() == null || exitingIssue.getIssueGroup().getId().equals(issue.getIssueGroup().getId()) && exitingIssue.getSprint().getId().equals(issue.getSprint().getId()))) {
            Integer seq = this.repository.getLastSeq(issue.getIssueGroup().getId(), issue.getSprint().getId());
            if (seq == null) {
                issue.setSeq(Integer.valueOf(0));
            } else {
                issue.setSeq(Integer.valueOf(seq + 1));
            }
        }
        if (issue.getComponent() != null && issue.getComponent().getId() != null && issue.getComponent().getName() == null) {
            issue.setComponent((Component)this.componentService.get(issue.getComponent().getId()));
        }
        return (Issue)super.update(id, (Entity)issue);
    }

    public Issue cloneIssue(Long issueId) {
        Issue sourceIssue = this.get(issueId);
        Issue clonedIssue = new Issue();
        BeanUtils.copyProperties((Object)sourceIssue, (Object)clonedIssue, (String[])new String[]{"id", "comments", "files", "linkToIssues", "linkedByIssues", "tags", "owner"});
        clonedIssue.setTags(new ArrayList(sourceIssue.getTags()));
        clonedIssue.setName("Copy of " + sourceIssue.getName());
        return (Issue)this.create((Entity)clonedIssue);
    }

    protected void beforeDelete(Issue issue) {
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(issue.getProject().getId())), (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
    }

    protected void afterDelete(Issue issue) {
        List files = issue.getFiles();
        if (!CollectionUtils.isEmpty((Collection)files)) {
            files.forEach(file -> this.fileService.delete(file.getId()));
            log.info("Deleted {} files of issue {}", (Object)files.size(), (Object)issue);
        }
        this.sprintService.refreshSprintIssueCount(issue.getSprint().getId());
    }

    public void moveIssuesToSprint(List<Long> issueIds, Long targetSprintId) {
        issueIds.forEach(id -> this.moveIssueToSprint(id, targetSprintId));
    }

    public List<IssueCountDto> countIssueByStatus(Long sprintId) {
        Sprint sprint = (Sprint)this.sprintService.get(sprintId);
        List issueGroups = sprint.getProject().getIssueGroups();
        List issueCountDtos = this.repository.countIssueByStatus(sprintId);
        issueGroups.forEach(issueGroup -> {
            boolean noneMatch = issueCountDtos.stream().noneMatch(dto -> {
                if (dto.getStoryPoints() == null) {
                    dto.setStoryPoints(Double.valueOf(0.0));
                }
                return dto.getIssueGroupId().equals(issueGroup.getId());
            });
            if (noneMatch) {
                issueCountDtos.add(new IssueCountDto(issueGroup.getId(), Long.valueOf(0L), Double.valueOf(0.0)));
            }
        });
        return issueCountDtos;
    }

    public List<Issue> findBySprintId(Long sprintId) {
        return this.repository.findBySprintId(sprintId);
    }

    public byte[] export(IssueFilter filter) {
        Long projectId = filter.getProjectId();
        if (projectId == null) {
            throw new BadRequestException("Project ID is required for issue search.");
        }
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(projectId)), (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        filter.getOrders().add(new Filter.Order("id", Filter.Direction.ASC));
        List issues = this.searchAll((Filter)filter);
        List<String> enHeaders = Arrays.asList("Key", "Title", "Type", "Priority", "Status", "Story point", "Component", "Estimated hours", "Actual hours", "Sprint", "Reporter", "Created time", "Updated time", "Due date", "Assignee", "Test case", "Test plan", "Tags", "Description", "Comments");
        List<String> cnHeaders = Arrays.asList("\u4ee3\u7801", "\u6807\u9898", "\u7c7b\u578b", "\u4f18\u5148\u7ea7", "\u72b6\u6001", "\u6545\u4e8b\u70b9", "\u529f\u80fd\u6a21\u5757", "\u9884\u4f30\u5de5\u65f6", "\u5b9e\u9645\u5de5\u65f6", "\u8fed\u4ee3", "\u63d0\u4ea4\u8005", "\u521b\u5efa\u65f6\u95f4", "\u66f4\u65b0\u65f6\u95f4", "\u622a\u6b62\u65f6\u95f4", "\u6267\u884c\u8005", "\u6d4b\u8bd5\u7528\u4f8b", "\u6d4b\u8bd5\u8ba1\u5212", "\u6807\u7b7e", "\u63cf\u8ff0", "\u8bc4\u8bba");
        byte[] result = Exporter.exportExcel((String)"Issues", "cn".equalsIgnoreCase(filter.getLanguage()) ? cnHeaders : enHeaders, (List)this.toExcelBodyRows(issues));
        log.info("Exported {} issues to Excel for filter: {}", (Object)issues.size(), (Object)filter);
        return result;
    }

    private List<List<Object>> toExcelBodyRows(List<Issue> issues) {
        return issues.stream().map(arg_0 -> this.toExcelBodyRow(arg_0)).toList();
    }

    private List<Object> toExcelBodyRow(Issue issue) {
        ArrayList<Object> cells = new ArrayList<Object>();
        cells.add(issue.getProject().getCode() + "-" + issue.getCode());
        cells.add(issue.getName());
        cells.add(issue.getType().name());
        cells.add(issue.getPriority().name());
        cells.add(issue.getIssueGroup() != null ? issue.getIssueGroup().getLabel() : null);
        cells.add(issue.getStoryPoints() != null ? issue.getStoryPoints() : null);
        cells.add(issue.getComponent() != null ? issue.getComponent().getName() : null);
        cells.add(issue.getEstimatedHours() != null ? issue.getEstimatedHours() : null);
        cells.add(issue.getActualHours() != null ? issue.getActualHours() : null);
        cells.add(issue.getSprint() != null ? issue.getSprint().getName() : null);
        cells.add(issue.getCreatedBy().getNickname());
        cells.add(issue.getCreatedTime());
        cells.add(issue.getUpdatedTime());
        cells.add(issue.getDueTime());
        cells.add(issue.getOwner() != null ? issue.getOwner().getNickname() : null);
        cells.add(issue.getTestCase() != null ? issue.getTestCase().getDetails().getName() : null);
        cells.add(issue.getTestPlan() != null ? issue.getTestPlan().getName() : null);
        cells.add(!CollectionUtils.isEmpty((Collection)issue.getTags()) ? this.getTagNames(issue) : null);
        cells.add(issue.getDescription());
        cells.add(!CollectionUtils.isEmpty((Collection)issue.getComments()) ? this.getComments(issue) : null);
        return cells;
    }

    private String getTagNames(Issue issue) {
        List<String> tagNames = issue.getTags().stream().map(Tag::getName).toList();
        return String.join((CharSequence)", ", tagNames);
    }

    private String getComments(Issue issue) {
        List<String> commentRows = issue.getComments().stream().map(Comment::format).toList();
        return String.join((CharSequence)";\n", commentRows);
    }

    @EventListener
    public void moveIssuesToParentComponent(EntityChangeEvent event) {
        Entity entity = Objects.requireNonNullElse(event.getPreviousEntity(), event.getUpdatedEntity());
        if (!(entity instanceof Component) || !EntityChangeEvent.ActionType.DELETE.equals((Object)event.getActionType())) {
            return;
        }
        Component component = (Component)event.getPreviousEntity();
        IssueFilter filter = new IssueFilter();
        filter.setPageSize(Integer.MAX_VALUE);
        filter.setComponentIds(Collections.singletonList(component.getId()));
        List issues = this.search(filter).getResults();
        if (!CollectionUtils.isEmpty((Collection)issues)) {
            issues.forEach(issue -> issue.setComponent(new Component(component.getParentId())));
            this.repository.saveAll((Iterable)issues);
            log.info("Updated {} issues' componentId to {} after deletion of component {}", new Object[]{issues.size(), component.getParentId(), component});
        }
    }
}

