/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.issue.service;

import com.shimi.gogoscrum.common.util.DateTimeUtil;
import com.shimi.gogoscrum.issue.service.IssueService;
import com.shimi.gogoscrum.sprint.model.SprintIssueCount;
import com.shimi.gogoscrum.sprint.service.SprintService;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IssueTaskScheduler {
    private static final Logger log = LoggerFactory.getLogger(IssueTaskScheduler.class);
    public static final int MAX_SPRINT_SPAN_DAYS = 365;
    @Autowired
    private IssueService issueService;
    @Autowired
    private SprintService sprintService;

    @Scheduled(cron="0 0 2 ? * *")
    public void countDailyIssueByStatus() {
        List activeSprints;
        long currentTimeMillis = System.currentTimeMillis();
        if (log.isTraceEnabled()) {
            log.trace("Started counting active sprint issues");
        }
        if (!CollectionUtils.isEmpty((Collection)(activeSprints = this.sprintService.findAllActiveSprints()))) {
            activeSprints.forEach(sprint -> {
                long spanDays = Duration.between(sprint.getStartDate().toInstant(), sprint.getEndDate().toInstant()).toDays();
                if (spanDays <= 365L) {
                    this.countDailyIssueByStatus(sprint.getId());
                    if (log.isDebugEnabled()) {
                        log.debug("Finished counting issues for Sprint (id={}, name={})", (Object)sprint.getId(), (Object)sprint.getName());
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("Ignored Sprint (id={}, name={}) which spans more than {} days", new Object[]{sprint.getId(), sprint.getName(), 365});
                }
            });
        }
        float timeSpent = (float)(System.currentTimeMillis() - currentTimeMillis) / 1000.0f;
        if (log.isDebugEnabled()) {
            log.debug("Finished count {} active sprint issues in {} seconds", (Object)activeSprints.size(), (Object)Float.valueOf(timeSpent));
        }
    }

    private void countDailyIssueByStatus(Long sprintId) {
        try {
            SprintIssueCount sprintIssueCount = this.getOrCreate(sprintId);
            Map dailyCounts = Optional.ofNullable(sprintIssueCount.getDailyCounts()).orElse(new LinkedHashMap());
            Date endingOfYesterday = DateTimeUtil.getEndingOfYesterday();
            String dateLabel = new SimpleDateFormat("yyyy-MM-dd").format(endingOfYesterday);
            dailyCounts.put(dateLabel, this.issueService.countIssueByStatus(sprintId));
            sprintIssueCount.setDailyCounts(dailyCounts);
            this.sprintService.saveSprintIssueCount(sprintIssueCount);
        }
        catch (Exception e) {
            log.error("Error caught while counting issue for sprint {}:", (Object)sprintId, (Object)e);
        }
    }

    private SprintIssueCount getOrCreate(Long sprintId) {
        SprintIssueCount sprintIssueCount = this.sprintService.getSprintIssueCount(sprintId);
        if (sprintIssueCount != null) {
            return sprintIssueCount;
        }
        return new SprintIssueCount(sprintId);
    }
}

