/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.project.controller;

import com.shimi.gogoscrum.common.controller.BaseController;
import com.shimi.gogoscrum.file.dto.FileDto;
import com.shimi.gogoscrum.project.dto.InvitationDto;
import com.shimi.gogoscrum.project.dto.ProjectDto;
import com.shimi.gogoscrum.project.dto.ProjectMemberDto;
import com.shimi.gogoscrum.project.dto.SprintVelocityDto;
import com.shimi.gogoscrum.project.model.Invitation;
import com.shimi.gogoscrum.project.model.InvitationFilter;
import com.shimi.gogoscrum.project.model.Project;
import com.shimi.gogoscrum.project.model.ProjectFilter;
import com.shimi.gogoscrum.project.model.ProjectMember;
import com.shimi.gogoscrum.project.model.ProjectMemberRole;
import com.shimi.gogoscrum.project.service.InvitationService;
import com.shimi.gogoscrum.project.service.ProjectService;
import com.shimi.gsf.core.dto.Dto;
import com.shimi.gsf.core.dto.DtoQueryResult;
import com.shimi.gsf.core.model.Entity;
import com.shimi.gsf.core.model.EntityQueryResult;
import com.shimi.gsf.core.model.Filter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/projects"})
@CrossOrigin
@Tag(name="Project", description="Project management")
@RolesAllowed(value={"ROLE_USER"})
public class ProjectController
extends BaseController {
    @Autowired
    private ProjectService projectService;
    @Autowired
    private InvitationService invitationService;

    @Operation(summary="Create a new project")
    @PostMapping
    public ProjectDto create(@RequestBody ProjectDto projectDto) {
        Project project = projectDto.toEntity();
        Project savedProject = (Project)this.projectService.create((Entity)project);
        return savedProject.toDto(true);
    }

    @Operation(summary="Search projects")
    @Parameters(value={@Parameter(name="filter", description="Project search filter")})
    @GetMapping
    public DtoQueryResult<Dto> search(ProjectFilter filter) {
        EntityQueryResult queryResult = this.projectService.search((Filter)Objects.requireNonNullElse(filter, new ProjectFilter()));
        return queryResult.toDto();
    }

    @Operation(summary="Get a project")
    @Parameters(value={@Parameter(name="id", description="The project ID")})
    @GetMapping(value={"/{id}"})
    public ProjectDto get(@PathVariable Long id) {
        Project project = (Project)this.projectService.get(id);
        return project.toDto(true);
    }

    @Operation(summary="Update a project")
    @Parameters(value={@Parameter(name="id", description="The project ID")})
    @PutMapping(value={"/{id}"})
    public ProjectDto update(@PathVariable Long id, @RequestBody ProjectDto projectDto) {
        Project updatedProject = (Project)this.projectService.update(id, (Entity)projectDto.toEntity());
        return updatedProject.toDto(true);
    }

    @Operation(summary="Delete a project")
    @Parameters(value={@Parameter(name="id", description="The project ID")})
    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable Long id) {
        this.projectService.delete(id);
    }

    @Operation(summary="Archive a project")
    @Parameters(value={@Parameter(name="id", description="The project ID")})
    @PostMapping(value={"/{id}/archive"})
    public ProjectDto archive(@PathVariable Long id) {
        return this.projectService.archive(id).toDto(true);
    }

    @Operation(summary="Unarchive a project")
    @Parameters(value={@Parameter(name="id", description="The project ID")})
    @DeleteMapping(value={"/{id}/archive"})
    public ProjectDto unarchive(@PathVariable Long id) {
        return this.projectService.unarchive(id).toDto(true);
    }

    @Operation(summary="Create a project invitation")
    @Parameters(value={@Parameter(name="id", description="The project ID")})
    @PostMapping(value={"/{id}/invitations"})
    public InvitationDto invite(@PathVariable Long id, @RequestBody InvitationDto invitationDto) {
        return ((Invitation)this.invitationService.create((Entity)invitationDto.toEntity())).toDto();
    }

    @Operation(summary="Update a project invitation")
    @Parameters(value={@Parameter(name="id", description="The project ID"), @Parameter(name="invitationId", description="The invitation ID")})
    @PutMapping(value={"/{id}/invitations/{invitationId}"})
    public InvitationDto updateInvitation(@PathVariable Long id, @PathVariable Long invitationId, @RequestBody InvitationDto invitationDto) {
        return ((Invitation)this.invitationService.update(invitationId, (Entity)invitationDto.toEntity())).toDto();
    }

    @Operation(summary="Join a project via invitation")
    @Parameters(value={@Parameter(name="invitationCode", description="The invitation code")})
    @PostMapping(value={"/invitations/{invitationCode}"})
    public ProjectDto joinProject(@PathVariable String invitationCode) {
        Project project = this.projectService.joinProject(invitationCode);
        return project.toDto(true);
    }

    @Operation(summary="Search project invitations")
    @Parameters(value={@Parameter(name="id", description="The project ID")})
    @GetMapping(value={"/{id}/invitations"})
    public DtoQueryResult<Dto> searchInvitations(@PathVariable Long id, InvitationFilter filter) {
        filter.setProjectId(id);
        EntityQueryResult queryResult = this.invitationService.search((Filter)filter);
        return queryResult.toDto();
    }

    @Operation(summary="Disable an invitation")
    @Parameters(value={@Parameter(name="id", description="The project ID"), @Parameter(name="invitationId", description="The invitation ID")})
    @DeleteMapping(value={"/{id}/invitations/{invitationId}/enable"})
    public InvitationDto disableInvitation(@PathVariable Long id, @PathVariable Long invitationId) {
        Invitation invitation = this.invitationService.disableInvitation(invitationId);
        return invitation.toDto();
    }

    @Operation(summary="Enable an invitation")
    @Parameters(value={@Parameter(name="id", description="The project ID"), @Parameter(name="invitationId", description="The invitation ID")})
    @PostMapping(value={"/{id}/invitations/{invitationId}/enable"})
    public InvitationDto enableInvitation(@PathVariable Long id, @PathVariable Long invitationId) {
        Invitation invitation = this.invitationService.enableInvitation(invitationId);
        return invitation.toDto();
    }

    @Operation(summary="Transfer project to new owner")
    @Parameters(value={@Parameter(name="id", description="The project ID"), @Parameter(name="userId", description="User ID of new owner"), @Parameter(name="quit", description="If to quit the project")})
    @PutMapping(value={"/{id}/owner"})
    public ProjectDto transfer(@PathVariable Long id, @RequestParam Long userId, @RequestParam(required=false) boolean quit) {
        Project project = this.projectService.transferTo(id, userId, quit);
        return project.toDto(true);
    }

    @Operation(summary="Create new project member")
    @Parameters(value={@Parameter(name="id", description="The project ID")})
    @PostMapping(value={"/{id}/members"})
    public ProjectMemberDto createMember(@PathVariable Long id, @RequestBody ProjectMemberDto projectMemberDto) {
        ProjectMember projectMember = projectMemberDto.toEntity();
        projectMember.setJoinChannel(ProjectMember.JoinChannel.MANUAL);
        ProjectMember savedProjectMember = this.projectService.createMember(projectMember);
        return savedProjectMember.toDto(true);
    }

    @Operation(summary="Delete a project member")
    @Parameters(value={@Parameter(name="id", description="The project ID"), @Parameter(name="memberId", description="The member ID")})
    @DeleteMapping(value={"/{id}/members/{memberId}"})
    public void deleteMember(@PathVariable Long id, @PathVariable Long memberId) {
        this.projectService.deleteMember(memberId);
    }

    @Operation(summary="Quit a project")
    @Parameters(value={@Parameter(name="id", description="The project ID")})
    @DeleteMapping(value={"/{id}/members/myself"})
    public void quitProject(@PathVariable Long id) {
        this.projectService.quitProject(id);
    }

    @Operation(summary="Set a member as guest")
    @Parameters(value={@Parameter(name="id", description="The project ID"), @Parameter(name="memberId", description="Project member ID")})
    @PutMapping(value={"/{id}/members/{memberId}/guest"})
    public ProjectMemberDto setAsGuest(@PathVariable Long memberId) {
        return this.projectService.updateMemberRole(memberId, ProjectMemberRole.GUEST).toDto(true);
    }

    @Operation(summary="Set a member as developer")
    @Parameters(value={@Parameter(name="id", description="The project ID"), @Parameter(name="memberId", description="Project member ID")})
    @PutMapping(value={"/{id}/members/{memberId}/developer"})
    public ProjectMemberDto setAsDeveloper(@PathVariable Long memberId) {
        return this.projectService.updateMemberRole(memberId, ProjectMemberRole.DEVELOPER).toDto(true);
    }

    @Operation(summary="Get project members by invitation")
    @Parameters(value={@Parameter(name="id", description="The project ID"), @Parameter(name="invitationId", description="The invitation ID"), @Parameter(name="page", description="The page number, starting from 1"), @Parameter(name="pageSize", description="The page size")})
    @GetMapping(value={"/{id}/members"})
    public DtoQueryResult<Dto> getMembers(@PathVariable Long id, @RequestParam(value="invitationId") Long invitationId, @RequestParam(value="page", defaultValue="1", required=false) int page, @RequestParam(value="pageSize", defaultValue="100", required=false) int pageSize) {
        EntityQueryResult queryResult = this.projectService.findMembersByInvitation(invitationId, page - 1, pageSize);
        return queryResult.toDto();
    }

    @Operation(summary="Update project avatar")
    @Parameters(value={@Parameter(name="id", description="The project ID"), @Parameter(name="fileDto", description="Avatar image file")})
    @PutMapping(value={"/{id}/avatar"})
    public ProjectDto updateAvatar(@PathVariable Long id, @RequestBody FileDto fileDto) {
        Project project = this.projectService.updateAvatar(id, fileDto.toEntity());
        return project.toDto();
    }

    @Operation(summary="Delete project avatar")
    @Parameters(value={@Parameter(name="id", description="The project ID")})
    @DeleteMapping(value={"/{id}/avatar"})
    public void deleteAvatar(@PathVariable Long id) {
        this.projectService.deleteAvatar(id);
    }

    @Operation(summary="Get team velocity of a project")
    @Parameters(value={@Parameter(name="id", description="The project ID")})
    @GetMapping(value={"/{id}/velocity"})
    public List<SprintVelocityDto> getProjectVelocity(@PathVariable Long id) {
        return this.projectService.getProjectVelocity(id);
    }
}

