/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.project.model;

import com.shimi.gogoscrum.common.model.BaseEntity;
import com.shimi.gogoscrum.file.model.File;
import com.shimi.gogoscrum.history.model.Historical;
import com.shimi.gogoscrum.issue.dto.IssueGroupDto;
import com.shimi.gogoscrum.issue.model.IssueGroup;
import com.shimi.gogoscrum.issue.model.IssueGroupStatus;
import com.shimi.gogoscrum.project.dto.ProjectDto;
import com.shimi.gogoscrum.project.dto.ProjectMemberDto;
import com.shimi.gogoscrum.project.model.ProjectMember;
import com.shimi.gogoscrum.project.model.ProjectMemberRole;
import com.shimi.gogoscrum.sprint.dto.SprintDto;
import com.shimi.gogoscrum.sprint.model.Sprint;
import com.shimi.gogoscrum.user.model.User;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

@Entity
@Table(name="project")
public class Project
extends BaseEntity
implements Historical {
    private static final long serialVersionUID = -1160435223851775784L;
    private String name;
    private String code;
    private Long lastIssueSeq;
    private Date startDate;
    private Date endDate;
    private boolean deleted = false;
    private boolean archived = false;
    @OneToOne
    @JoinColumn(name="avatar_file_id")
    private File avatar;
    private String description;
    private Boolean timeTrackingEnabled = false;
    private Long fileCount = 0L;
    private Long totalFileSize = 0L;
    @OneToMany(cascade={CascadeType.REMOVE}, mappedBy="project", fetch=FetchType.LAZY)
    @OrderBy(value="startDate DESC, id DESC")
    private List<Sprint> sprints = new ArrayList();
    @OneToMany(cascade={CascadeType.REMOVE}, mappedBy="project", fetch=FetchType.LAZY)
    @OrderBy(value="seq ASC")
    private List<IssueGroup> issueGroups = new ArrayList();
    @OneToMany(cascade={CascadeType.REMOVE}, mappedBy="project", fetch=FetchType.LAZY)
    private List<ProjectMember> projectMembers = new ArrayList();

    public Project(Long projectId) {
        this.id = projectId;
    }

    public Project() {
    }

    public ProjectDto toDto() {
        return this.toDto(false);
    }

    public ProjectDto toDto(boolean detailed) {
        ProjectDto dto = new ProjectDto();
        BeanUtils.copyProperties((Object)this, (Object)dto, (String[])new String[]{"sprints", "users", "owner", "issueGroups", "projectMembers"});
        if (this.getOwner() != null) {
            dto.setOwner(this.getOwner().toDto().normalize());
        }
        if (this.avatar != null) {
            dto.setAvatar(this.avatar.toDto().normalize());
        }
        if (detailed) {
            if (!CollectionUtils.isEmpty((Collection)this.projectMembers)) {
                List<ProjectMemberDto> projectMemberDtos = this.projectMembers.stream().map(ProjectMember::toDto).toList();
                dto.setProjectMembers(projectMemberDtos);
            }
            if (!CollectionUtils.isEmpty((Collection)this.sprints)) {
                List<SprintDto> sprintDtos = this.sprints.stream().map(Sprint::toDto).toList();
                dto.setSprints(sprintDtos);
            }
            if (!CollectionUtils.isEmpty((Collection)this.issueGroups)) {
                List<IssueGroupDto> issueGroupDtos = this.issueGroups.stream().map(IssueGroup::toDto).toList();
                dto.setIssueGroups(issueGroupDtos);
            }
        }
        return dto;
    }

    public User getOwner() {
        Optional<ProjectMember> owner = this.getProjectMembers().stream().filter(participator -> ProjectMemberRole.OWNER.equals((Object)participator.getRole())).findFirst();
        return owner.map(ProjectMember::getUser).orElse(null);
    }

    public ProjectMember getMemberByUserId(Long userId) {
        Optional<ProjectMember> member = this.getProjectMembers().stream().filter(participator -> participator.getUser().getId().equals(userId)).findFirst();
        return member.orElse(null);
    }

    public ProjectMember getOwnerMember() {
        Optional<ProjectMember> member = this.getProjectMembers().stream().filter(participator -> ProjectMemberRole.OWNER.equals((Object)participator.getRole())).findFirst();
        return member.orElse(null);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getLastIssueSeq() {
        return this.lastIssueSeq;
    }

    public void setLastIssueSeq(Long lastIssueSeq) {
        this.lastIssueSeq = lastIssueSeq;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public List<Sprint> getSprints() {
        return this.sprints;
    }

    public void setSprints(List<Sprint> sprints) {
        this.sprints = sprints;
    }

    public Sprint getBacklogSprint() {
        if (!CollectionUtils.isEmpty((Collection)this.sprints)) {
            return this.sprints.stream().filter(Sprint::getBacklog).findFirst().orElse(null);
        }
        return null;
    }

    public List<IssueGroup> getIssueGroups() {
        return this.issueGroups;
    }

    public void setIssueGroups(List<IssueGroup> issueGroups) {
        this.issueGroups = issueGroups;
    }

    public IssueGroup getToDoIssueGroup() {
        return this.issueGroups.stream().filter(group -> IssueGroupStatus.TO_DO.equals((Object)group.getStatus())).findFirst().orElse(null);
    }

    public List<ProjectMember> getProjectMembers() {
        return this.projectMembers;
    }

    public void setProjectMembers(List<ProjectMember> projectMembers) {
        this.projectMembers = projectMembers;
    }

    public File getAvatar() {
        return this.avatar;
    }

    public void setAvatar(File avatar) {
        this.avatar = avatar;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getTimeTrackingEnabled() {
        return this.timeTrackingEnabled;
    }

    public void setTimeTrackingEnabled(Boolean timeTrackingEnabled) {
        this.timeTrackingEnabled = timeTrackingEnabled;
    }

    public Long getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(Long fileCount) {
        this.fileCount = fileCount;
    }

    public Long getTotalFileSize() {
        return this.totalFileSize;
    }

    public void setTotalFileSize(Long totalFileSize) {
        this.totalFileSize = totalFileSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Project{");
        sb.append("id=").append(this.id);
        sb.append(", code='").append(this.code).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public String getDetails() {
        return "id=" + this.id + ", name='" + this.name + "', code='" + this.code;
    }
}

