/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.project.model;

import com.shimi.gogoscrum.common.model.BaseEntity;
import com.shimi.gogoscrum.project.dto.ProjectMemberDto;
import com.shimi.gogoscrum.project.model.Project;
import com.shimi.gogoscrum.project.model.ProjectMember;
import com.shimi.gogoscrum.project.model.ProjectMemberRole;
import com.shimi.gogoscrum.user.model.User;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import org.springframework.beans.BeanUtils;

@Entity
public class ProjectMember
extends BaseEntity {
    private static final long serialVersionUID = 3968021065061271934L;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="project_id")
    private Project project;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id")
    private User user;
    @Enumerated(value=EnumType.STRING)
    private ProjectMemberRole role;
    @Enumerated(value=EnumType.STRING)
    private JoinChannel joinChannel;
    private Long invitationId;

    public ProjectMember() {
    }

    public ProjectMember(Project project, User user) {
        this.project = project;
        this.user = user;
    }

    public ProjectMember(Project project, User user, ProjectMemberRole role) {
        this.project = project;
        this.user = user;
        this.role = role;
    }

    public ProjectMemberDto toDto() {
        return this.toDto(false);
    }

    public ProjectMemberDto toDto(boolean detailed) {
        ProjectMemberDto dto = new ProjectMemberDto();
        BeanUtils.copyProperties((Object)this, (Object)dto, (String[])new String[]{"project", "user"});
        dto.setUser(this.user.toDto());
        if (detailed) {
            dto.setProject(this.project.toDto());
        }
        return dto;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public ProjectMemberRole getRole() {
        return this.role;
    }

    public void setRole(ProjectMemberRole role) {
        this.role = role;
    }

    public JoinChannel getJoinChannel() {
        return this.joinChannel;
    }

    public void setJoinChannel(JoinChannel joinChannel) {
        this.joinChannel = joinChannel;
    }

    public Long getInvitationId() {
        return this.invitationId;
    }

    public void setInvitationId(Long invitationId) {
        this.invitationId = invitationId;
    }

    public String toString() {
        return "ProjectMember{project=" + this.project.getId() + ", user=" + this.user.getId() + ", type=" + String.valueOf(this.role) + "}";
    }
}

