/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.project.repository;

import com.shimi.gogoscrum.project.model.Invitation;
import jakarta.persistence.criteria.Expression;
import java.io.Serializable;
import java.util.Date;
import org.springframework.data.jpa.domain.Specification;

public class InvitationSpecs {
    private InvitationSpecs() {
        throw new IllegalStateException("Utility class");
    }

    public static Specification<Invitation> codeLike(String code) {
        return (Specification & Serializable)(invitation, criteriaQuery, criteriaBuilder) -> criteriaBuilder.like((Expression)invitation.get("code"), "%" + code + "%");
    }

    public static Specification<Invitation> projectIdEqual(Long projectId) {
        return (Specification & Serializable)(invitation, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)invitation.get("projectId"), (Object)projectId);
    }

    public static Specification<Invitation> disabled() {
        return (Specification & Serializable)(invitation, criteriaQuery, criteriaBuilder) -> criteriaBuilder.isFalse((Expression)invitation.get("enabled"));
    }

    public static Specification<Invitation> enabled() {
        return (Specification & Serializable)(invitation, criteriaQuery, criteriaBuilder) -> criteriaBuilder.isTrue((Expression)invitation.get("enabled"));
    }

    public static Specification<Invitation> expired() {
        return (Specification & Serializable)(invitation, criteriaQuery, criteriaBuilder) -> criteriaBuilder.lessThanOrEqualTo((Expression)invitation.get("expireTime"), (Comparable)new Date());
    }

    public static Specification<Invitation> notExpired() {
        Specification & Serializable expireTimeNull = (Specification & Serializable)(invitation, criteriaQuery, criteriaBuilder) -> criteriaBuilder.isNull((Expression)invitation.get("expireTime"));
        Specification & Serializable expireTimeInFuture = (Specification & Serializable)(invitation, criteriaQuery, criteriaBuilder) -> criteriaBuilder.greaterThan((Expression)invitation.get("expireTime"), (Comparable)new Date());
        return expireTimeNull.or((Specification)expireTimeInFuture);
    }
}

