/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.project.repository;

import com.shimi.gogoscrum.project.model.Project;
import com.shimi.gogoscrum.user.model.User;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import java.io.Serializable;
import org.springframework.data.jpa.domain.Specification;

public class ProjectSpecs {
    private ProjectSpecs() {
    }

    public static Specification<Project> nameLike(String keyword) {
        return (Specification & Serializable)(project, criteriaQuery, criteriaBuilder) -> criteriaBuilder.like((Expression)project.get("name"), "%" + keyword + "%");
    }

    public static Specification<Project> codeLike(String keyword) {
        return (Specification & Serializable)(project, criteriaQuery, criteriaBuilder) -> criteriaBuilder.like((Expression)project.get("code"), "%" + keyword + "%");
    }

    public static Specification<Project> deletedEquals(Boolean deleted) {
        return (Specification & Serializable)(project, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)project.get("deleted"), (Object)deleted);
    }

    public static Specification<Project> archivedEquals(Boolean archived) {
        return (Specification & Serializable)(project, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)project.get("archived"), (Object)archived);
    }

    public static Specification<Project> isProjectMember(User user) {
        return (Specification & Serializable)(project, criteriaQuery, criteriaBuilder) -> {
            Join join = project.join("projectMembers", JoinType.INNER);
            return criteriaBuilder.equal((Expression)join.get("user").get("id"), (Object)user.getId());
        };
    }
}

