/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.project.service;

import com.shimi.gogoscrum.common.service.BaseServiceImpl;
import com.shimi.gogoscrum.common.util.DateTimeUtil;
import com.shimi.gogoscrum.common.util.RandomToolkit;
import com.shimi.gogoscrum.project.model.Invitation;
import com.shimi.gogoscrum.project.model.InvitationFilter;
import com.shimi.gogoscrum.project.model.Project;
import com.shimi.gogoscrum.project.repository.InvitationRepository;
import com.shimi.gogoscrum.project.repository.InvitationSpecs;
import com.shimi.gogoscrum.project.service.InvitationService;
import com.shimi.gogoscrum.project.service.ProjectService;
import com.shimi.gogoscrum.project.utils.ProjectMemberUtils;
import com.shimi.gsf.core.exception.BaseServiceException;
import com.shimi.gsf.core.model.User;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class InvitationServiceImpl
extends BaseServiceImpl<Invitation, InvitationFilter>
implements InvitationService {
    private static final Logger log = LoggerFactory.getLogger(InvitationServiceImpl.class);
    public static final int INVITATION_CODE_LENGTH = 12;
    public static final int INVITATION_CODE_MAX_TRY = 3;
    @Autowired
    InvitationRepository repository;
    @Autowired
    ProjectService projectService;

    protected InvitationRepository getRepository() {
        return this.repository;
    }

    protected void beforeCreate(Invitation invitation) {
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(invitation.getProjectId())), (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        this.preprocess(invitation);
    }

    protected void beforeUpdate(Long id, Invitation existingEntity, Invitation newEntity) {
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(newEntity.getProjectId())), (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        this.preprocess(newEntity);
    }

    private void preprocess(Invitation invitation) {
        if (invitation.getId() == null) {
            invitation.setCode(this.generateNewCode());
        }
        if (invitation.getValidDays() == null || invitation.getValidDays() >= 9999) {
            invitation.setExpireTime(null);
        } else {
            invitation.setExpireTime(DateTimeUtil.daysLater((int)invitation.getValidDays()));
        }
    }

    private String generateNewCode() {
        for (int i = 0; i < 3; ++i) {
            String randomString = RandomToolkit.getRandomString((int)12);
            Invitation invitation = this.findByCode(randomString);
            if (invitation == null) {
                return randomString;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Duplicated invitation code {} generated, will try again", (Object)randomString);
        }
        throw new BaseServiceException("invitationCodeGenerationFail", "Failed to generate new invitation code after max tries", HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public Invitation findByCode(String invitationCode) {
        return this.repository.findByCode(invitationCode);
    }

    public Long increaseJoinCount(Long id) {
        Invitation invitation = (Invitation)this.get(id);
        Long joinCount = Optional.ofNullable(invitation.getJoinCount()).orElse(0L);
        invitation.setJoinCount(Long.valueOf(joinCount + 1L));
        this.repository.save((Object)invitation);
        if (log.isDebugEnabled()) {
            log.debug("Increased joinCount of invitation {} to {}", (Object)id, (Object)invitation.getJoinCount());
        }
        return invitation.getJoinCount();
    }

    protected Specification<Invitation> toSpec(InvitationFilter filter) {
        Specification querySpec = null;
        if (filter.getProjectId() == null) {
            throw new BaseServiceException("invalidRequestData", "Project ID is required to query invitations", HttpStatus.BAD_REQUEST);
        }
        querySpec = InvitationSpecs.projectIdEqual((Long)filter.getProjectId());
        if (StringUtils.hasText((String)filter.getCode())) {
            Specification codeLike = InvitationSpecs.codeLike((String)filter.getCode());
            querySpec = querySpec.and(codeLike);
        }
        if (filter.getActive() != null) {
            Specification statusSpec = null;
            statusSpec = filter.getActive() != false ? InvitationSpecs.enabled().and(InvitationSpecs.notExpired()) : InvitationSpecs.disabled().or(InvitationSpecs.expired());
            querySpec = querySpec.and(statusSpec);
        }
        return querySpec;
    }

    public Invitation disableInvitation(Long id) {
        return this.updatedInvitationStatus(id, Boolean.FALSE);
    }

    public Invitation enableInvitation(Long id) {
        return this.updatedInvitationStatus(id, Boolean.TRUE);
    }

    private Invitation updatedInvitationStatus(Long id, Boolean status) {
        Invitation invitation = (Invitation)this.get(id);
        if (invitation.getEnabled() == null || !invitation.getEnabled().equals(status)) {
            com.shimi.gogoscrum.user.model.User currentUser = this.getCurrentUser();
            invitation.setEnabled(status);
            invitation.setUpdateTraceInfo((User)currentUser);
            this.repository.save((Object)invitation);
            log.info("Invitation {} enable status updated to {} by user {}", new Object[]{invitation, status, currentUser});
        } else if (log.isDebugEnabled()) {
            log.info("Invitation {} enable status is already in {}", (Object)invitation, (Object)status);
        }
        return invitation;
    }
}

