/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.project.service;

import com.shimi.gogoscrum.common.service.BaseServiceImpl;
import com.shimi.gogoscrum.common.util.DateTimeUtil;
import com.shimi.gogoscrum.file.model.File;
import com.shimi.gogoscrum.file.model.TargetType;
import com.shimi.gogoscrum.file.service.FileService;
import com.shimi.gogoscrum.issue.model.IssueGroup;
import com.shimi.gogoscrum.issue.model.IssueGroupStatus;
import com.shimi.gogoscrum.issue.service.IssueGroupService;
import com.shimi.gogoscrum.project.dto.SprintVelocityDto;
import com.shimi.gogoscrum.project.model.Invitation;
import com.shimi.gogoscrum.project.model.Project;
import com.shimi.gogoscrum.project.model.ProjectFilter;
import com.shimi.gogoscrum.project.model.ProjectMember;
import com.shimi.gogoscrum.project.model.ProjectMemberRole;
import com.shimi.gogoscrum.project.repository.ProjectMemberRepository;
import com.shimi.gogoscrum.project.repository.ProjectRepository;
import com.shimi.gogoscrum.project.repository.ProjectSpecs;
import com.shimi.gogoscrum.project.service.InvitationService;
import com.shimi.gogoscrum.project.service.ProjectService;
import com.shimi.gogoscrum.project.utils.ProjectMemberUtils;
import com.shimi.gogoscrum.sprint.service.SprintService;
import com.shimi.gsf.core.event.EntityChangeEvent;
import com.shimi.gsf.core.exception.BaseServiceException;
import com.shimi.gsf.core.exception.EntityNotFoundException;
import com.shimi.gsf.core.exception.NoPermissionException;
import com.shimi.gsf.core.model.Entity;
import com.shimi.gsf.core.model.EntityQueryResult;
import com.shimi.gsf.core.model.User;
import com.shimi.gsf.util.PageQueryResultConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class ProjectServiceImpl
extends BaseServiceImpl<Project, ProjectFilter>
implements ProjectService {
    private static final Logger log = LoggerFactory.getLogger(ProjectServiceImpl.class);
    @Autowired
    private ProjectRepository repository;
    @Autowired
    private ProjectMemberRepository memberRepository;
    @Autowired
    private SprintService sprintService;
    @Autowired
    private IssueGroupService issueGroupService;
    @Autowired
    private InvitationService invitationService;
    @Autowired
    private FileService fileService;

    protected ProjectRepository getRepository() {
        return this.repository;
    }

    public Project get(Long id) {
        Project project = (Project)super.get(id);
        ProjectMemberUtils.checkMember((Project)project, (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        return project;
    }

    protected void beforeCreate(Project project) {
        project.setLastIssueSeq(Long.valueOf(0L));
        if (StringUtils.hasText((String)project.getName())) {
            if (project.getStartDate() != null) {
                project.setStartDate(DateTimeUtil.getBeginningOfDay((Date)project.getStartDate()));
            }
            if (project.getEndDate() != null) {
                project.setEndDate(DateTimeUtil.getEndingOfDay((Date)project.getEndDate()));
            }
        } else {
            throw new BaseServiceException("invalidRequestData", "The project name cannot be empty", HttpStatus.BAD_REQUEST);
        }
    }

    protected void afterCreate(Project project) {
        ProjectMember owner = new ProjectMember(project, this.getCurrentUser(), ProjectMemberRole.OWNER);
        owner.setJoinChannel(ProjectMember.JoinChannel.CREATOR);
        owner.setAllTraceInfo((User)this.getCurrentUser());
        project.getProjectMembers().add((ProjectMember)this.memberRepository.save((Object)owner));
        this.sprintService.createBacklog(project);
        this.createBuiltInGroups(project);
    }

    private void createBuiltInGroups(Project project) {
        ArrayList<IssueGroup> defaultIssueGroups = new ArrayList<IssueGroup>();
        short seq = 0;
        for (IssueGroupStatus status : IssueGroupStatus.values()) {
            short s = seq;
            seq = (short)(seq + 1);
            defaultIssueGroups.add(this.newBuiltInGroup(project, s, status));
        }
        List savedIssueGroups = this.issueGroupService.saveAll(defaultIssueGroups);
        project.getIssueGroups().addAll(savedIssueGroups);
        if (log.isDebugEnabled()) {
            log.debug("Created built-in issue groups for project {}: {}", (Object)project.getId(), (Object)savedIssueGroups);
        }
    }

    private IssueGroup newBuiltInGroup(Project project, short seq, IssueGroupStatus status) {
        IssueGroup issueGroup = new IssueGroup();
        issueGroup.setProject(project);
        issueGroup.setLabel(status.toString().replace("_", " "));
        issueGroup.setAllTraceInfo((User)this.getCurrentUser());
        issueGroup.setBuiltIn(true);
        issueGroup.setSeq(seq);
        issueGroup.setStatus(status);
        return issueGroup;
    }

    protected void beforeUpdate(Long projectId, Project existingProject, Project project) {
        ProjectMemberUtils.checkOwner((Project)existingProject, (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        if (!StringUtils.hasText((String)project.getName())) {
            throw new BaseServiceException("invalidRequestData", "The project name cannot be empty", HttpStatus.BAD_REQUEST);
        }
        if (project.getStartDate() != null) {
            project.setStartDate(DateTimeUtil.getBeginningOfDay((Date)project.getStartDate()));
        }
        if (project.getEndDate() != null) {
            project.setEndDate(DateTimeUtil.getEndingOfDay((Date)project.getEndDate()));
        }
    }

    protected void afterUpdate(Long projectId, Project existingProject, Project updatedProject) {
        updatedProject.setProjectMembers(existingProject.getProjectMembers());
    }

    protected String[] getUpdateIgnoredProps() {
        return new String[]{"id", "avatar", "lastIssueSeq", "issueGroups", "createdTime", "createdBy", "fileCount", "totalFileSize"};
    }

    public String generateNextIssueCode(Long projectId) {
        Project project = this.get(projectId);
        Long nextIssueSeq = project.getLastIssueSeq() + 1L;
        String nextIssueCode = String.valueOf(nextIssueSeq);
        project.setLastIssueSeq(nextIssueSeq);
        this.repository.save((Object)project);
        if (log.isDebugEnabled()) {
            log.debug("New issue seq {} generated for project {}", (Object)nextIssueCode, (Object)projectId);
        }
        return nextIssueCode;
    }

    protected Specification<Project> toSpec(ProjectFilter filter) {
        com.shimi.gogoscrum.user.model.User currentUser = this.getCurrentUser();
        Specification querySpec = ProjectSpecs.isProjectMember((com.shimi.gogoscrum.user.model.User)currentUser);
        if (StringUtils.hasText((String)filter.getKeyword())) {
            String keyword = filter.getKeyword();
            Specification nameLike = ProjectSpecs.codeLike((String)keyword).or(ProjectSpecs.nameLike((String)keyword));
            querySpec = querySpec.and(nameLike);
        }
        if (filter.getDeleted() != null) {
            Specification deletedSpec = ProjectSpecs.deletedEquals((Boolean)filter.getDeleted());
            querySpec = querySpec.and(deletedSpec);
        }
        if (filter.getArchived() != null) {
            Specification archivedSpec = ProjectSpecs.archivedEquals((Boolean)filter.getArchived());
            querySpec = querySpec.and(archivedSpec);
        }
        return querySpec;
    }

    public void delete(Long id) {
        Project project = this.get(id);
        ProjectMemberUtils.checkOwner((Project)project, (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        project.setDeleted(true);
        project.setUpdateTraceInfo((User)this.getCurrentUser());
        this.repository.save((Object)project);
        log.info("Soft deleted Project: {}", (Object)project);
    }

    public Project archive(Long id) {
        Project project = this.get(id);
        ProjectMemberUtils.checkOwner((Project)project, (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        project.setArchived(true);
        project.setUpdateTraceInfo((User)this.getCurrentUser());
        Project updatedProject = (Project)this.repository.save((Object)project);
        log.info("Archived Project: {}", (Object)project);
        return updatedProject;
    }

    public Project unarchive(Long id) {
        Project project = this.get(id);
        ProjectMemberUtils.checkOwner((Project)project, (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        project.setArchived(false);
        Project updatedProject = (Project)this.repository.save((Object)project);
        log.info("Unarchived Project: {}", (Object)project);
        return updatedProject;
    }

    public Project joinProject(String invitationCode) {
        com.shimi.gogoscrum.user.model.User currentUser;
        Invitation invitation = this.invitationService.findByCode(invitationCode);
        if (invitation == null || Boolean.FALSE.equals(invitation.getEnabled()) || invitation.getExpireTime() != null && invitation.getExpireTime().before(new Date())) {
            throw new BaseServiceException("invalidInvitation", "Project invitation doesn't exist, expired or disabled", HttpStatus.NOT_ACCEPTABLE);
        }
        Project project = (Project)super.get(invitation.getProjectId());
        if (ProjectMemberUtils.isMember((Project)project, (com.shimi.gogoscrum.user.model.User)(currentUser = this.getCurrentUser()))) {
            HashMap<String, Long> extendValues = new HashMap<String, Long>();
            extendValues.put("projectId", invitation.getProjectId());
            throw new BaseServiceException("alreadyInProject", "You're already in the project", HttpStatus.NOT_ACCEPTABLE, extendValues);
        }
        ProjectMember projectMember = new ProjectMember(project, currentUser);
        projectMember.setRole(ProjectMemberRole.valueOf((String)invitation.getInvitationType().toString()));
        projectMember.setJoinChannel(ProjectMember.JoinChannel.INVITATION);
        projectMember.setInvitationId(invitation.getId());
        projectMember.setAllTraceInfo((User)currentUser);
        project.getProjectMembers().add((ProjectMember)this.memberRepository.save((Object)projectMember));
        log.info("User {} joined project {} via invitation {}", new Object[]{currentUser.getId(), project.getId(), invitation.getId()});
        this.invitationService.increaseJoinCount(invitation.getId());
        return project;
    }

    public void quitProject(Long projectId) {
        com.shimi.gogoscrum.user.model.User currentUser = this.getCurrentUser();
        ProjectMember member = this.memberRepository.findByProjectIdAndUserId(projectId, currentUser.getId());
        if (member == null) {
            throw new NoPermissionException("You are not a member of the project");
        }
        if (ProjectMemberRole.OWNER.equals((Object)member.getRole())) {
            throw new NoPermissionException("Project owner cannot quit the project without transferring ownership");
        }
        this.memberRepository.delete((Object)member);
        log.info("User {} quit project {}", (Object)currentUser.getId(), (Object)projectId);
    }

    public List<SprintVelocityDto> getProjectVelocity(Long projectId) {
        Project project = this.get(projectId);
        List velocities = this.repository.getProjectVelocity(projectId);
        Map velocityDtoMap = velocities.stream().collect(Collectors.toMap(SprintVelocityDto::getSprintId, Function.identity()));
        List sprints = project.getSprints();
        Collections.reverse(sprints);
        return sprints.stream().filter(sprint -> sprint.getBacklog() == false).map(sprint -> Optional.ofNullable((SprintVelocityDto)velocityDtoMap.get(sprint.getId())).orElse(new SprintVelocityDto(sprint.getId(), sprint.getName(), sprint.getStartDate(), sprint.getEndDate(), Long.valueOf(0L), Double.valueOf(0.0)))).toList();
    }

    public Project transferTo(Long projectId, Long newOwnerUserId, boolean quit) {
        Project project = this.get(projectId);
        ProjectMember oldOwnerMember = project.getOwnerMember();
        Long oldOwnerUserId = oldOwnerMember.getUser().getId();
        com.shimi.gogoscrum.user.model.User currentUser = this.getCurrentUser();
        if (currentUser.getId().equals(oldOwnerUserId)) {
            ProjectMember newOwnerMember = project.getMemberByUserId(newOwnerUserId);
            if (newOwnerMember != null) {
                newOwnerMember.setRole(ProjectMemberRole.OWNER);
                newOwnerMember.setUpdateTraceInfo((User)currentUser);
                this.memberRepository.save((Object)newOwnerMember);
                log.info("Project {} transferred from original owner {} to new owner {}", new Object[]{projectId, oldOwnerUserId, newOwnerUserId});
                if (quit) {
                    this.memberRepository.delete((Object)oldOwnerMember);
                    log.info("Old owner {} quit project {}", (Object)oldOwnerUserId, (Object)projectId);
                } else {
                    oldOwnerMember.setRole(ProjectMemberRole.DEVELOPER);
                    oldOwnerMember.setUpdateTraceInfo((User)currentUser);
                    this.memberRepository.save((Object)oldOwnerMember);
                    log.info("Updated project {} owner {} to {}", new Object[]{projectId, oldOwnerUserId, oldOwnerMember.getRole()});
                }
                return this.get(projectId);
            }
            throw new BaseServiceException("invalidRequestData", "The specified new owner is not a member of the project", HttpStatus.PRECONDITION_FAILED);
        }
        throw new NoPermissionException("You are not the owner of the project");
    }

    public ProjectMember createMember(ProjectMember member) {
        ProjectMemberUtils.checkDeveloper((Project)this.get(member.getProject().getId()), (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        ProjectMember existingMember = this.memberRepository.findByProjectIdAndUserId(member.getProject().getId(), member.getUser().getId());
        if (existingMember != null) {
            throw new BaseServiceException("alreadyInProject", "User is already a member of the project", HttpStatus.NOT_ACCEPTABLE);
        }
        member.setAllTraceInfo((User)this.getCurrentUser());
        ProjectMember savedMember = (ProjectMember)this.memberRepository.save((Object)member);
        log.info("Project member created: {}", (Object)savedMember);
        return member;
    }

    public void deleteMember(Long memberId) {
        ProjectMember member = (ProjectMember)this.memberRepository.findById((Object)memberId).orElseThrow(() -> new EntityNotFoundException("Project member not found by id: " + memberId));
        ProjectMemberUtils.checkMember((Project)member.getProject(), (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        if (ProjectMemberRole.OWNER.equals((Object)member.getRole())) {
            throw new NoPermissionException("Project owner cannot be deleted");
        }
        if (!member.getUser().getId().equals(this.getCurrentUser().getId())) {
            ProjectMemberUtils.checkOwner((Project)member.getProject(), (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        }
        this.memberRepository.delete((Object)member);
        log.info("Project member deleted: {}", (Object)member);
    }

    public ProjectMember updateMemberRole(Long memberId, ProjectMemberRole role) {
        ProjectMember result = null;
        Optional memberOptional = this.memberRepository.findById((Object)memberId);
        if (memberOptional.isPresent()) {
            ProjectMember member = (ProjectMember)memberOptional.get();
            ProjectMemberRole oldRole = member.getRole();
            ProjectMemberUtils.checkOwner((Project)member.getProject(), (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
            if (role != null && !Objects.equals(member.getRole(), role)) {
                member.setRole(role);
                member.setUpdateTraceInfo(this.getCurrentUser(true));
                result = (ProjectMember)this.memberRepository.save((Object)member);
                log.debug("Project member {} role updated from {} to {}", new Object[]{memberId, oldRole, role});
            } else {
                result = member;
                if (log.isDebugEnabled()) {
                    log.debug("Project member {} role {} not changed, request will be ignored.", (Object)memberId, (Object)role);
                }
            }
        } else {
            throw new EntityNotFoundException("Project member not found by id: " + memberId);
        }
        return result;
    }

    public EntityQueryResult<ProjectMember> findMembersByInvitation(Long invitationId, int page, int pageSize) {
        Page members = this.memberRepository.findByInvitationId(invitationId, (Pageable)PageRequest.of((int)page, (int)pageSize, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"}));
        return PageQueryResultConverter.toQueryResult((Page)members);
    }

    public Project updateAvatar(Long projectId, File avatarFile) {
        Project project = this.get(projectId);
        ProjectMemberUtils.checkOwner((Project)project, (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        Long oldFileId = null;
        if (project.getAvatar() != null) {
            oldFileId = project.getAvatar().getId();
        }
        File savedAvatar = (File)this.fileService.create((Entity)avatarFile);
        project.setAvatar(savedAvatar);
        project.setUpdateTraceInfo((User)this.getCurrentUser());
        Project updatedProject = (Project)this.repository.save((Object)project);
        if (oldFileId != null) {
            this.fileService.delete(oldFileId);
        }
        log.info("Project {} avatar file updated to {}", (Object)projectId, (Object)savedAvatar.getId());
        this.updateFileCountAndTotalSize(projectId, 1L, avatarFile.getSize().longValue());
        return updatedProject;
    }

    public void deleteAvatar(Long projectId) {
        Project project = this.get(projectId);
        ProjectMemberUtils.checkOwner((Project)project, (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        File avatarFile = project.getAvatar();
        if (avatarFile != null) {
            Long fileId = avatarFile.getId();
            project.setAvatar(null);
            project.setUpdateTraceInfo((User)this.getCurrentUser());
            this.repository.save((Object)project);
            this.fileService.delete(fileId);
            log.info("Project {} avatar file {} deleted.", (Object)projectId, (Object)fileId);
            this.updateFileCountAndTotalSize(projectId, -1L, -avatarFile.getSize().longValue());
        } else {
            log.warn("Project {} has no avatar file to delete", (Object)projectId);
        }
    }

    @EventListener
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void onFileChanged(EntityChangeEvent event) {
        File file;
        Entity entity = Objects.requireNonNullElse(event.getUpdatedEntity(), event.getPreviousEntity());
        EntityChangeEvent.ActionType actionType = event.getActionType();
        if (!(entity instanceof File) || (file = (File)entity).getFolder().booleanValue() || file.getProjectId() == null || Objects.equals(file.getTargetType(), TargetType.PROJECT_AVATAR) || EntityChangeEvent.ActionType.UPDATE.equals((Object)actionType)) {
            return;
        }
        Long projectId = file.getProjectId();
        this.updateFileCountAndTotalSize(projectId, EntityChangeEvent.ActionType.CREATE.equals((Object)actionType) ? 1L : -1L, EntityChangeEvent.ActionType.CREATE.equals((Object)actionType) ? file.getSize() : -file.getSize().longValue());
        if (log.isDebugEnabled()) {
            log.debug("Project {} file count and total file size refreshed.", (Object)projectId);
        }
    }

    private void updateFileCountAndTotalSize(Long projectId, long fileCountDiff, long sizeDiff) {
        this.repository.updateFileCountAndTotalSize(projectId, fileCountDiff, sizeDiff);
        log.debug("Project {} file count diff {}, total size diff {}", new Object[]{projectId, fileCountDiff, sizeDiff});
    }
}

