/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.project.utils;

import com.shimi.gogoscrum.project.model.Project;
import com.shimi.gogoscrum.project.model.ProjectMember;
import com.shimi.gogoscrum.project.model.ProjectMemberRole;
import com.shimi.gogoscrum.user.model.User;
import com.shimi.gsf.core.exception.NoPermissionException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProjectMemberUtils {
    public static boolean isMember(Project project, User user) {
        return project.getProjectMembers().stream().anyMatch(participator -> participator.getUser().getId().equals(user.getId()));
    }

    public static void checkMember(Project project, User user) {
        if (!ProjectMemberUtils.isMember((Project)project, (User)user)) {
            throw new NoPermissionException("You are not a member of the project");
        }
    }

    public static void checkDeveloper(Project project, User user) {
        if (!ProjectMemberUtils.hasRole((Project)project, (User)user, Arrays.asList(ProjectMemberRole.OWNER, ProjectMemberRole.DEVELOPER))) {
            throw new NoPermissionException("You are not a developer of the project");
        }
    }

    public static void checkOwner(Project project, User user) {
        if (!user.getId().equals(project.getOwner().getId())) {
            throw new NoPermissionException("You are not the owner of the project");
        }
    }

    private static boolean hasRole(Project project, User user, List<ProjectMemberRole> roles) {
        Optional<ProjectMember> currentProjectMember = project.getProjectMembers().stream().filter(projectMember -> projectMember.getUser().getId().equals(user.getId())).findFirst();
        if (currentProjectMember.isEmpty()) {
            throw new NoPermissionException("You are not a member of the project");
        }
        ProjectMemberRole role = currentProjectMember.get().getRole();
        return roles.contains(role);
    }
}

