/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.socket;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.shimi.gogoscrum.issue.event.GroupSeqUpdatedEvent;
import com.shimi.gogoscrum.issue.event.IssueSeqUpdatedEvent;
import com.shimi.gogoscrum.issue.model.Issue;
import com.shimi.gogoscrum.issue.model.IssueGroup;
import com.shimi.gogoscrum.socket.BoardChangedEvent;
import com.shimi.gogoscrum.user.model.User;
import com.shimi.gsf.core.event.EntityChangeEvent;
import com.shimi.gsf.core.model.Entity;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.PathParam;
import jakarta.websocket.server.ServerEndpoint;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/websocket/{projectId}/{sprintId}")
public class WebSocketServer {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServer.class);
    private static final AtomicInteger onlineCount = new AtomicInteger(0);
    private static final Map<String, Long> sessionSprintMap = new ConcurrentHashMap();
    private static final Map<String, Long> sessionProjectMap = new ConcurrentHashMap();
    private static final Map<Long, List<Session>> sprintSessionPool = new ConcurrentHashMap();
    private static final Map<Long, List<Session>> projectSessionPool = new ConcurrentHashMap();

    @OnOpen
    public void onOpen(Session session, @PathParam(value="projectId") Long projectId, @PathParam(value="sprintId") Long sprintId) {
        this.addSessionIntoPool(session, projectId, sprintId);
        int joinedCount = onlineCount.incrementAndGet();
        session.setMaxIdleTimeout(0L);
        this.startHeartbeat(session);
        if (log.isDebugEnabled()) {
            log.debug("New websocket connected to sprint board {} by session {} from user {}, total online users is {} now", new Object[]{sprintId, session.getId(), this.getUserFromSession(session), joinedCount});
        }
    }

    private void startHeartbeat(Session session) {
        try {
            session.getAsyncRemote().sendPing(ByteBuffer.wrap("ping".getBytes()));
        }
        catch (IOException e) {
            log.error("Failed to send ping to session {}: {}", new Object[]{session.getId(), e.getMessage(), e});
        }
    }

    private User getUserFromSession(Session session) {
        Principal userPrincipal = session.getUserPrincipal();
        if (userPrincipal != null) {
            return (User)((Authentication)userPrincipal).getPrincipal();
        }
        return null;
    }

    @OnClose
    public void onClose(Session session) {
        this.removeSessionFromPool(session);
        int joinedCount = onlineCount.decrementAndGet();
        if (log.isDebugEnabled()) {
            log.debug("Websocket connection closed by session {} from user {},  total online users is {} now", new Object[]{session.getId(), this.getUserFromSession(session), joinedCount});
        }
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
        if (throwable instanceof EOFException) {
            if (log.isDebugEnabled()) {
                log.debug("Websocket connection error occurred by session {} from user {}", (Object)session.getId(), (Object)this.getUserFromSession(session));
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Websocket error in session {} from user {}: {}", new Object[]{session.getId(), this.getUserFromSession(session), throwable.getMessage(), throwable});
        }
        try {
            session.close();
        }
        catch (IOException e) {
            log.error("Failed to close websocket session {}: {}", new Object[]{session.getId(), e.getMessage(), e});
        }
    }

    @EventListener
    public void onIssueOrGroupChange(EntityChangeEvent event) {
        Entity entity = Objects.requireNonNullElse(event.getUpdatedEntity(), event.getPreviousEntity());
        if (entity instanceof IssueGroup) {
            this.onGroupChanged(event);
        } else if (entity instanceof Issue) {
            this.onIssueChanged(event);
        }
    }

    private void onIssueChanged(EntityChangeEvent event) {
        if (log.isTraceEnabled()) {
            log.trace("Issue change event received: {}", (Object)event);
        }
        Issue issue = (Issue)Objects.requireNonNullElse(event.getUpdatedEntity(), event.getPreviousEntity());
        BoardChangedEvent boardEvent = this.toBoardEvent(issue, event.getActionType());
        this.broadcastBoardEvent(boardEvent);
        if (event.getActionType().equals((Object)EntityChangeEvent.ActionType.UPDATE)) {
            Issue oldIssue = (Issue)event.getPreviousEntity();
            if (!Objects.equals(issue.getSprint().getId(), oldIssue.getSprint().getId())) {
                boardEvent.setSprintId(oldIssue.getSprint().getId());
                this.broadcastBoardEvent(boardEvent);
            }
        }
    }

    private void onGroupChanged(EntityChangeEvent event) {
        if (log.isTraceEnabled()) {
            log.trace("Issue group change event received: {}", (Object)event);
        }
        IssueGroup issueGroup = (IssueGroup)Objects.requireNonNullElse(event.getUpdatedEntity(), event.getPreviousEntity());
        this.broadcastBoardEvent(this.toBoardEvent(issueGroup, event.getActionType()));
    }

    @EventListener
    public void onIssueSeqChanged(IssueSeqUpdatedEvent event) {
        if (log.isTraceEnabled()) {
            log.trace("Issue sequence change event received: {}", (Object)event);
        }
        this.broadcastBoardEvent(this.toBoardEvent(event));
    }

    @EventListener
    public void onGroupSeqChanged(GroupSeqUpdatedEvent event) {
        if (log.isTraceEnabled()) {
            log.trace("Issue group sequence change event received: {}", (Object)event);
        }
        this.broadcastBoardEvent(this.toBoardEvent(event));
    }

    private BoardChangedEvent toBoardEvent(Issue issue, EntityChangeEvent.ActionType actionType) {
        BoardChangedEvent boardEvent = new BoardChangedEvent();
        User updatedBy = issue.getUpdatedBy();
        boardEvent.setSprintId(issue.getSprint() != null ? issue.getSprint().getId() : null);
        boardEvent.setEventType(BoardChangedEvent.BoardEventType.ISSUE_CHANGED);
        boardEvent.setActionType(actionType);
        boardEvent.setSourceId(issue.getId());
        boardEvent.setSourceName(issue.getProject().getCode() + "-" + issue.getCode());
        boardEvent.setUpdatedByUserId(updatedBy.getId());
        boardEvent.setUpdatedByUserNickname(updatedBy.getNickname());
        boardEvent.setUpdatedByUserAvatar(updatedBy.getAvatarUrl());
        return boardEvent;
    }

    private BoardChangedEvent toBoardEvent(IssueSeqUpdatedEvent seqEvent) {
        BoardChangedEvent boardEvent = new BoardChangedEvent();
        IssueGroup issueGroup = (IssueGroup)seqEvent.getSource();
        User updatedBy = seqEvent.getUpdatedBy();
        boardEvent.setSprintId(seqEvent.getSprintId());
        boardEvent.setEventType(BoardChangedEvent.BoardEventType.ISSUE_SEQ_CHANGED);
        boardEvent.setActionType(seqEvent.getActionType());
        boardEvent.setSourceId(issueGroup.getId());
        boardEvent.setSourceName(issueGroup.getLabel());
        boardEvent.setUpdatedByUserId(updatedBy.getId());
        boardEvent.setUpdatedByUserNickname(updatedBy.getNickname());
        boardEvent.setUpdatedByUserAvatar(updatedBy.getAvatarUrl());
        return boardEvent;
    }

    private BoardChangedEvent toBoardEvent(IssueGroup group, EntityChangeEvent.ActionType actionType) {
        BoardChangedEvent boardEvent = new BoardChangedEvent();
        User updatedBy = group.getUpdatedBy();
        boardEvent.setProjectId(group.getProject().getId());
        boardEvent.setEventType(BoardChangedEvent.BoardEventType.ISSUE_GROUP_CHANGED);
        boardEvent.setActionType(actionType);
        boardEvent.setSourceId(group.getId());
        boardEvent.setSourceName(group.getLabel());
        boardEvent.setUpdatedByUserId(updatedBy.getId());
        boardEvent.setUpdatedByUserNickname(updatedBy.getNickname());
        boardEvent.setUpdatedByUserAvatar(updatedBy.getAvatarUrl());
        return boardEvent;
    }

    private BoardChangedEvent toBoardEvent(GroupSeqUpdatedEvent seqEvent) {
        BoardChangedEvent boardEvent = new BoardChangedEvent();
        User updatedBy = seqEvent.getUpdatedBy();
        boardEvent.setProjectId(seqEvent.getProjectId());
        boardEvent.setEventType(BoardChangedEvent.BoardEventType.ISSUE_GROUP_SEQ_CHANGED);
        boardEvent.setActionType(seqEvent.getActionType());
        boardEvent.setUpdatedByUserId(updatedBy.getId());
        boardEvent.setUpdatedByUserNickname(updatedBy.getNickname());
        boardEvent.setUpdatedByUserAvatar(updatedBy.getAvatarUrl());
        return boardEvent;
    }

    private void broadcastBoardEvent(BoardChangedEvent boardChangedEvent) {
        Long sprintId = boardChangedEvent.getSprintId();
        Long projectId = boardChangedEvent.getProjectId();
        if (sprintId != null && sprintSessionPool.containsKey(sprintId)) {
            this.sendBoardEvent((List)sprintSessionPool.get(sprintId), boardChangedEvent);
        } else if (projectId != null && projectSessionPool.containsKey(projectId)) {
            this.sendBoardEvent((List)projectSessionPool.get(projectId), boardChangedEvent);
        }
    }

    private void sendBoardEvent(List<Session> sessions, BoardChangedEvent boardEvent) {
        try {
            ObjectMapper mapper = new ObjectMapper().registerModule((Module)new SimpleModule().addSerializer(Long.class, (JsonSerializer)new ToStringSerializer()));
            String msgBody = mapper.writeValueAsString((Object)boardEvent);
            sessions.forEach(session -> {
                User userFromSession = this.getUserFromSession(session);
                Long updatedByUserId = boardEvent.getUpdatedByUserId();
                if (userFromSession != null && !userFromSession.getId().equals(updatedByUserId)) {
                    this.sendMsg(session, msgBody);
                }
            });
        }
        catch (JsonProcessingException e) {
            log.error("Error caught while parsing BoardChangedEvent to string:", (Throwable)e);
        }
    }

    public void sendMsg(Session session, String message) {
        try {
            session.getBasicRemote().sendText(message);
            if (log.isTraceEnabled()) {
                log.trace("Websocket msg sent to session {} for user: {}", (Object)session.getId(), (Object)this.getUserFromSession(session));
            }
        }
        catch (IOException e) {
            log.error("Failed to send websocket message:", (Throwable)e);
        }
    }

    private void addSessionIntoPool(Session session, Long projectId, Long sprintId) {
        CopyOnWriteArrayList<Session> sessions;
        sessionSprintMap.put(session.getId(), sprintId);
        sessionProjectMap.put(session.getId(), projectId);
        if (!sprintSessionPool.containsKey(sprintId)) {
            sessions = new CopyOnWriteArrayList<Session>(Arrays.asList(session));
            sprintSessionPool.put(sprintId, sessions);
        } else {
            ((List)sprintSessionPool.get(sprintId)).add(session);
        }
        if (!projectSessionPool.containsKey(projectId)) {
            sessions = new CopyOnWriteArrayList<Session>(Arrays.asList(session));
            projectSessionPool.put(projectId, sessions);
        } else {
            ((List)projectSessionPool.get(projectId)).add(session);
        }
    }

    private void removeSessionFromPool(Session session) {
        Long sprintId = (Long)sessionSprintMap.get(session.getId());
        Long projectId = (Long)sessionProjectMap.get(session.getId());
        if (sprintId != null && sprintSessionPool.containsKey(sprintId)) {
            sessionSprintMap.remove(session.getId());
            ((List)sprintSessionPool.get(sprintId)).remove(session);
        }
        if (projectId != null && projectSessionPool.containsKey(projectId)) {
            sessionProjectMap.remove(session.getId());
            ((List)projectSessionPool.get(projectId)).remove(session);
        }
    }
}

