/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.sprint.controller;

import com.shimi.gogoscrum.common.controller.BaseController;
import com.shimi.gogoscrum.issue.dto.CumulativeFlowDiagramDto;
import com.shimi.gogoscrum.sprint.dto.SprintDto;
import com.shimi.gogoscrum.sprint.model.Sprint;
import com.shimi.gogoscrum.sprint.service.SprintService;
import com.shimi.gsf.core.model.Entity;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sprints"})
@CrossOrigin
@Tag(name="Sprint", description="Project sprint Management")
@RolesAllowed(value={"ROLE_USER"})
public class SprintController
extends BaseController {
    @Autowired
    private SprintService sprintService;

    @Operation(summary="Create a sprint")
    @PostMapping
    public SprintDto create(@RequestBody SprintDto sprintDto) {
        Sprint sprint = sprintDto.toEntity();
        Sprint savedSprint = (Sprint)this.sprintService.create((Entity)sprint);
        return savedSprint.toDto(true);
    }

    @Operation(summary="Get a sprint")
    @Parameters(value={@Parameter(name="id", description="The sprint ID")})
    @GetMapping(value={"/{id}"})
    public SprintDto get(@PathVariable Long id) {
        Sprint sprint = (Sprint)this.sprintService.get(id);
        return sprint.toDto(true);
    }

    @Operation(summary="Update a sprint")
    @Parameters(value={@Parameter(name="id", description="The sprint ID")})
    @PutMapping(value={"/{id}"})
    public SprintDto update(@PathVariable Long id, @RequestBody SprintDto sprintDto) {
        Sprint updateSprint = (Sprint)this.sprintService.update(id, (Entity)sprintDto.toEntity());
        return updateSprint.toDto();
    }

    @Operation(summary="Delete a sprint", description="After the deletion of the Sprint, all the contained issues will be moved into project Backlog. Only the project owner or the creator of the Sprint can delete that Sprint.")
    @Parameters(value={@Parameter(name="id", description="The sprint ID")})
    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable Long id) {
        this.sprintService.delete(id);
    }

    @Operation(summary="Get sprint cumulative flow diagram")
    @Parameters(value={@Parameter(name="id", description="The sprint ID")})
    @GetMapping(value={"/{id}/charts/cumulative"})
    public CumulativeFlowDiagramDto getSprintCumulativeFlowDiagram(@PathVariable Long id) {
        return this.sprintService.getSprintCumulativeFlowDiagram(id);
    }
}

