/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.sprint.model;

import com.shimi.gogoscrum.common.model.BaseEntity;
import com.shimi.gogoscrum.history.model.Historical;
import com.shimi.gogoscrum.issue.dto.IssueDto;
import com.shimi.gogoscrum.issue.model.Issue;
import com.shimi.gogoscrum.project.model.Project;
import com.shimi.gogoscrum.sprint.dto.SprintDto;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

@Entity
@Table(name="sprint")
public class Sprint
extends BaseEntity
implements Historical {
    private static final long serialVersionUID = -5837280105424829935L;
    private String name;
    private String goal;
    private Boolean backlog = Boolean.FALSE;
    private Date startDate;
    private Date endDate;
    private Long totalIssueCount = 0L;
    private Long doneIssueCount = 0L;
    @ManyToOne
    @JoinColumn(name="project_id")
    private Project project;
    @OneToMany(mappedBy="sprint", fetch=FetchType.LAZY)
    @OrderBy(value="seq ASC, priority DESC, storyPoints ASC, id ASC")
    private List<Issue> issues = new ArrayList();

    public SprintDto toDto() {
        return this.toDto(false);
    }

    public SprintDto toDto(boolean detailed) {
        return this.toDto(detailed, detailed);
    }

    public SprintDto toDto(boolean createdBy, boolean detailed) {
        SprintDto dto = new SprintDto();
        BeanUtils.copyProperties((Object)this, (Object)dto, (String[])new String[]{"issues", "project"});
        if (createdBy && this.createdBy != null) {
            dto.setCreatedBy(this.createdBy.toDto());
        }
        if (detailed) {
            if (!CollectionUtils.isEmpty((Collection)this.issues)) {
                List<IssueDto> issueDtos = this.issues.stream().map(Issue::toDtoForList).toList();
                dto.setIssues(issueDtos);
            }
            if (this.project != null) {
                dto.setProject(this.project.toDto());
            }
        }
        return dto;
    }

    public Sprint() {
    }

    public Sprint(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public void setIssues(List<Issue> issues) {
        this.issues = issues;
    }

    public Boolean getBacklog() {
        return this.backlog;
    }

    public void setBacklog(Boolean backlog) {
        this.backlog = backlog;
    }

    public String getGoal() {
        return this.goal;
    }

    public void setGoal(String goal) {
        this.goal = goal;
    }

    public Float getProgress() {
        if (this.totalIssueCount != null && this.totalIssueCount > 0L) {
            return Float.valueOf((float)(this.doneIssueCount != null ? this.doneIssueCount : 0L) / (float)this.totalIssueCount.longValue());
        }
        return Float.valueOf(0.0f);
    }

    public Long getTotalIssueCount() {
        return this.totalIssueCount;
    }

    public void setTotalIssueCount(Long totalIssueCount) {
        this.totalIssueCount = totalIssueCount;
    }

    public Long getDoneIssueCount() {
        return this.doneIssueCount;
    }

    public void setDoneIssueCount(Long doneIssueCount) {
        this.doneIssueCount = doneIssueCount;
    }

    public boolean isActive() {
        Date now = new Date();
        return this.startDate != null && this.endDate != null && this.startDate.before(now) && this.endDate.after(now);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Sprint{");
        sb.append("id=").append(this.id);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", projectId=").append(this.project.getId());
        sb.append('}');
        return sb.toString();
    }

    public String getDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append("id=").append(this.id);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", projectId=").append(this.project.getId());
        return sb.toString();
    }
}

