/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.sprint.service;

import com.shimi.gogoscrum.common.service.BaseServiceImpl;
import com.shimi.gogoscrum.common.util.DateTimeUtil;
import com.shimi.gogoscrum.issue.dto.CumulativeFlowDiagramDto;
import com.shimi.gogoscrum.issue.model.Issue;
import com.shimi.gogoscrum.issue.repository.IssueRepository;
import com.shimi.gogoscrum.issue.service.IssueService;
import com.shimi.gogoscrum.project.model.Project;
import com.shimi.gogoscrum.project.service.ProjectService;
import com.shimi.gogoscrum.project.utils.ProjectMemberUtils;
import com.shimi.gogoscrum.sprint.model.Sprint;
import com.shimi.gogoscrum.sprint.model.SprintFilter;
import com.shimi.gogoscrum.sprint.model.SprintIssueCount;
import com.shimi.gogoscrum.sprint.repository.SprintIssueCountRepository;
import com.shimi.gogoscrum.sprint.repository.SprintRepository;
import com.shimi.gogoscrum.sprint.service.SprintService;
import com.shimi.gogoscrum.user.model.User;
import com.shimi.gsf.core.exception.BaseServiceException;
import com.shimi.gsf.core.exception.NoPermissionException;
import com.shimi.gsf.core.model.Entity;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SprintServiceImpl
extends BaseServiceImpl<Sprint, SprintFilter>
implements SprintService {
    private static final Logger log = LoggerFactory.getLogger(SprintServiceImpl.class);
    @Autowired
    private SprintRepository repository;
    @Autowired
    private IssueRepository issueRepository;
    @Autowired
    private SprintIssueCountRepository sprintIssueCountRepository;
    @Autowired
    private ProjectService projectService;
    @Autowired
    @Lazy
    private IssueService issueService;

    protected SprintRepository getRepository() {
        return this.repository;
    }

    public Sprint get(Long id) {
        Sprint sprint = (Sprint)super.get(id);
        ProjectMemberUtils.checkMember((Project)sprint.getProject(), (User)this.getCurrentUser());
        return sprint;
    }

    protected void beforeCreate(Sprint sprint) {
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(sprint.getProject().getId())), (User)this.getCurrentUser());
        this.validate(sprint);
    }

    private void validate(Sprint sprint) {
        if (StringUtils.hasText((String)sprint.getName())) {
            if (sprint.getStartDate() != null && sprint.getEndDate() != null) {
                sprint.setStartDate(DateTimeUtil.getBeginningOfDay((Date)sprint.getStartDate()));
                sprint.setEndDate(DateTimeUtil.getEndingOfDay((Date)sprint.getEndDate()));
            }
        } else {
            throw new BaseServiceException("invalidRequestData", "The sprint name cannot be empty", HttpStatus.BAD_REQUEST);
        }
    }

    protected void beforeDelete(Sprint sprint) {
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(sprint.getProject().getId())), (User)this.getCurrentUser());
        Long currentUserId = this.getCurrentUser().getId();
        Long projectOwnerId = sprint.getProject().getOwner().getId();
        Long sprintCreatorId = sprint.getCreatedBy().getId();
        if (!projectOwnerId.equals(currentUserId) && !sprintCreatorId.equals(currentUserId)) {
            throw new NoPermissionException("Only project owner or sprint creator can delete a sprint.");
        }
        if (Boolean.TRUE.equals(sprint.getBacklog())) {
            throw new BaseServiceException("backlogCannotBeDeleted", "Project backlog cannot be deleted.", HttpStatus.PRECONDITION_FAILED);
        }
        Project project = sprint.getProject();
        Sprint backlogSprint = project.getBacklogSprint();
        if (backlogSprint == null) {
            backlogSprint = this.createBacklog(project);
        }
        List issues = sprint.getIssues();
        for (Issue issue : issues) {
            issue.setSprint(backlogSprint);
        }
        this.issueRepository.saveAll((Iterable)issues);
        log.debug("{} issues moved into project Backlog: {}", (Object)issues.size(), (Object)backlogSprint);
    }

    public Sprint createBacklog(Project project) {
        Sprint backLog = new Sprint();
        backLog.setName("Backlog");
        backLog.setBacklog(Boolean.valueOf(true));
        backLog.setProject(project);
        Sprint savedBacklog = (Sprint)this.create((Entity)backLog);
        project.getSprints().add(savedBacklog);
        return savedBacklog;
    }

    protected void beforeUpdate(Long id, Sprint existingEntity, Sprint newEntity) {
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(existingEntity.getProject().getId())), (User)this.getCurrentUser());
        this.validate(newEntity);
    }

    public List<Sprint> findAllActiveSprints() {
        Date endingOfYesterday = DateTimeUtil.getEndingOfYesterday();
        return this.repository.findAllActiveSprints(endingOfYesterday);
    }

    public SprintIssueCount getSprintIssueCount(Long sprintId) {
        return this.sprintIssueCountRepository.findBySprintId(sprintId);
    }

    public CumulativeFlowDiagramDto getSprintCumulativeFlowDiagram(Long sprintId) {
        SprintIssueCount sprintIssueCount = this.getSprintIssueCount(sprintId);
        Sprint sprint = this.get(sprintId);
        CumulativeFlowDiagramDto cumulativeFlowDiagramDto = this.initCumulativeFlowDiagramDto(sprint);
        if (sprintIssueCount != null) {
            if (sprint.isActive()) {
                String todayDateLabel = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
                sprintIssueCount.getDailyCounts().put(todayDateLabel, this.issueService.countIssueByStatus(sprintId));
            }
            this.fillInDailyCounts(sprintIssueCount, cumulativeFlowDiagramDto);
        }
        return cumulativeFlowDiagramDto;
    }

    private CumulativeFlowDiagramDto initCumulativeFlowDiagramDto(Sprint sprint) {
        CumulativeFlowDiagramDto cumulativeFlowDiagramDto = new CumulativeFlowDiagramDto(sprint.getId());
        Project project = sprint.getProject();
        Map groupLines = cumulativeFlowDiagramDto.getGroupLines();
        project.getIssueGroups().forEach(group -> groupLines.put(group.getId(), new CumulativeFlowDiagramDto.StatusGroupLineDto(group.getId(), group.getLabel())));
        return cumulativeFlowDiagramDto;
    }

    private void fillInDailyCounts(SprintIssueCount sprintIssueCount, CumulativeFlowDiagramDto cumulativeFlowDiagramDto) {
        sprintIssueCount.getDailyCounts().forEach((key, countsByGroup) -> {
            Map groupLines = cumulativeFlowDiagramDto.getGroupLines();
            if (!CollectionUtils.isEmpty((Collection)countsByGroup)) {
                countsByGroup.forEach(groupCount -> {
                    Long groupId = groupCount.getIssueGroupId();
                    CumulativeFlowDiagramDto.StatusGroupLineDto groupLineDto = (CumulativeFlowDiagramDto.StatusGroupLineDto)groupLines.get(groupId);
                    Map dailyCounts = groupLineDto.getDailyCounts();
                    dailyCounts.put(key, new CumulativeFlowDiagramDto.DailyCountDto(groupCount.getCount(), groupCount.getStoryPoints()));
                });
            }
        });
    }

    public SprintIssueCount saveSprintIssueCount(SprintIssueCount sprintIssueCount) {
        return (SprintIssueCount)this.sprintIssueCountRepository.save((Object)sprintIssueCount);
    }

    public void refreshSprintIssueCount(Long sprintId) {
        Sprint sprint = (Sprint)this.repository.getReferenceById((Object)sprintId);
        long oldTotalIssueCount = sprint.getTotalIssueCount();
        long oldDoneIssueCount = sprint.getDoneIssueCount();
        List issues = this.issueService.findBySprintId(sprintId);
        long totalIssueCount = issues.size();
        long doneIssueCount = issues.stream().filter(Issue::isDone).count();
        if (totalIssueCount != oldTotalIssueCount || doneIssueCount != oldDoneIssueCount) {
            sprint.setTotalIssueCount(Long.valueOf(totalIssueCount));
            sprint.setDoneIssueCount(Long.valueOf(doneIssueCount));
            this.repository.save((Object)sprint);
            if (log.isDebugEnabled()) {
                log.debug("Updated issue count of sprint {}: total {} -> {}, done {} -> {}", new Object[]{sprintId, oldTotalIssueCount, totalIssueCount, oldDoneIssueCount, doneIssueCount});
            }
        }
    }

    protected Specification<Sprint> toSpec(SprintFilter filter) {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

