/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.tag.controller;

import com.shimi.gogoscrum.common.controller.BaseController;
import com.shimi.gogoscrum.tag.dto.TagDto;
import com.shimi.gogoscrum.tag.model.TagFilter;
import com.shimi.gogoscrum.tag.service.TagService;
import com.shimi.gsf.core.dto.Dto;
import com.shimi.gsf.core.dto.DtoQueryResult;
import com.shimi.gsf.core.model.Entity;
import com.shimi.gsf.core.model.EntityQueryResult;
import com.shimi.gsf.core.model.Filter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tags"})
@CrossOrigin
@Tag(name="Tag", description="Tag Management")
@RolesAllowed(value={"ROLE_USER"})
public class TagController
extends BaseController {
    @Autowired
    private TagService tagService;

    @Operation(summary="Create a new tag")
    @PostMapping
    public TagDto create(@RequestBody TagDto tagDto) {
        com.shimi.gogoscrum.tag.model.Tag tag = tagDto.toEntity();
        com.shimi.gogoscrum.tag.model.Tag savedTag = (com.shimi.gogoscrum.tag.model.Tag)this.tagService.create((Entity)tag);
        return savedTag.toDto(true);
    }

    @Operation(summary="Search tags")
    @Parameters(value={@Parameter(name="filter", description="The search filter")})
    @GetMapping
    public DtoQueryResult<Dto> search(TagFilter filter) {
        filter = Objects.requireNonNullElse(filter, new TagFilter());
        EntityQueryResult queryResult = this.tagService.search((Filter)filter);
        return queryResult.toDto(true);
    }

    @Operation(summary="Get a tag")
    @Parameters(value={@Parameter(name="id", description="The tag ID")})
    @GetMapping(value={"/{id}"})
    public TagDto get(@PathVariable Long id) {
        com.shimi.gogoscrum.tag.model.Tag tag = (com.shimi.gogoscrum.tag.model.Tag)this.tagService.get(id);
        return tag.toDto(true);
    }

    @Operation(summary="Update a tag")
    @Parameters(value={@Parameter(name="id", description="The tag ID")})
    @PutMapping(value={"/{id}"})
    public TagDto update(@PathVariable Long id, @RequestBody TagDto tagDto) {
        com.shimi.gogoscrum.tag.model.Tag tag = tagDto.toEntity();
        com.shimi.gogoscrum.tag.model.Tag updateTag = (com.shimi.gogoscrum.tag.model.Tag)this.tagService.update(id, (Entity)tag);
        return updateTag.toDto(true);
    }

    @Operation(summary="Delete a tag")
    @Parameters(value={@Parameter(name="id", description="The tag ID")})
    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable Long id) {
        this.tagService.delete(id);
    }
}

