/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.tag.service;

import com.shimi.gogoscrum.common.service.BaseServiceImpl;
import com.shimi.gogoscrum.project.model.Project;
import com.shimi.gogoscrum.project.service.ProjectService;
import com.shimi.gogoscrum.project.utils.ProjectMemberUtils;
import com.shimi.gogoscrum.tag.model.Tag;
import com.shimi.gogoscrum.tag.model.TagFilter;
import com.shimi.gogoscrum.tag.repository.TagRepository;
import com.shimi.gogoscrum.tag.repository.TagSpecs;
import com.shimi.gogoscrum.tag.service.TagService;
import com.shimi.gogoscrum.user.model.User;
import com.shimi.gsf.core.exception.BaseServiceException;
import com.shimi.gsf.core.exception.EntityDuplicatedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class TagServiceImpl
extends BaseServiceImpl<Tag, TagFilter>
implements TagService {
    private static final Logger log = LoggerFactory.getLogger(TagServiceImpl.class);
    @Autowired
    private TagRepository repository;
    @Autowired
    private ProjectService projectService;

    protected TagRepository getRepository() {
        return this.repository;
    }

    public Tag get(Long id) {
        Tag tag = (Tag)super.get(id);
        ProjectMemberUtils.checkMember((Project)((Project)this.projectService.get(tag.getProjectId())), (User)this.getCurrentUser());
        return tag;
    }

    protected void beforeCreate(Tag tag) {
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(tag.getProjectId())), (User)this.getCurrentUser());
        Tag duplicatedTag = this.repository.findByNameAndProjectId(tag.getName(), tag.getProjectId());
        if (duplicatedTag != null) {
            throw new EntityDuplicatedException("Duplicated tag already exists in project");
        }
    }

    public void beforeUpdate(Long id, Tag existingEntity, Tag newTag) {
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(existingEntity.getProjectId())), (User)this.getCurrentUser());
        Tag duplicatedTag = this.repository.findByNameAndProjectId(newTag.getName(), newTag.getProjectId());
        if (duplicatedTag != null && !duplicatedTag.getId().equals(newTag.getId())) {
            throw new BaseServiceException("duplicatedTag", "Duplicated tag name already exists", HttpStatus.CONFLICT);
        }
    }

    protected void beforeDelete(Tag tag) {
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(tag.getProjectId())), (User)this.getCurrentUser());
    }

    protected Specification<Tag> toSpec(TagFilter filter) {
        Specification querySpec = null;
        if (filter.getProjectId() == null) {
            throw new BaseServiceException("invalidRequestData", "Project ID must be provided", HttpStatus.BAD_REQUEST);
        }
        querySpec = TagSpecs.projectIdEquals((Long)filter.getProjectId());
        if (StringUtils.hasText((String)filter.getKeyword())) {
            Specification nameLike = TagSpecs.nameLike((String)filter.getKeyword());
            querySpec = querySpec.and(nameLike);
        }
        return querySpec;
    }
}

