/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.testing.controller;

import com.shimi.gogoscrum.common.controller.BaseController;
import com.shimi.gogoscrum.testing.dto.TestCaseDetailsDto;
import com.shimi.gogoscrum.testing.dto.TestCaseDto;
import com.shimi.gogoscrum.testing.model.TestCase;
import com.shimi.gogoscrum.testing.model.TestCaseFilter;
import com.shimi.gogoscrum.testing.service.TestCaseService;
import com.shimi.gsf.core.dto.Dto;
import com.shimi.gsf.core.dto.DtoQueryResult;
import com.shimi.gsf.core.model.Entity;
import com.shimi.gsf.core.model.EntityQueryResult;
import com.shimi.gsf.core.model.Filter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/testing/cases"})
@CrossOrigin
@Tag(name="Test case", description="Test case Management")
@RolesAllowed(value={"ROLE_USER"})
public class TestCaseController
extends BaseController {
    @Autowired
    private TestCaseService testCaseService;

    @Operation(summary="Create a test case")
    @PostMapping
    public TestCaseDto create(@RequestBody TestCaseDto testCaseDto) {
        TestCase testCase = testCaseDto.toEntity();
        TestCase savedTestCase = (TestCase)this.testCaseService.create((Entity)testCase);
        return savedTestCase.toDto(true);
    }

    @Operation(summary="Get test case")
    @Parameters(value={@Parameter(name="id", description="The test case ID")})
    @GetMapping(value={"/{id}"})
    public TestCaseDto get(@PathVariable Long id) {
        return ((TestCase)this.testCaseService.get(id)).toDto(true);
    }

    @Operation(summary="Get test cases details by version")
    @Parameters(value={@Parameter(name="id", description="The test case ID"), @Parameter(name="version", description="The version of the test case. ")})
    @GetMapping(value={"/{id}/details/{version}"})
    public TestCaseDetailsDto getDetails(@PathVariable Long id, @PathVariable Integer version) {
        return this.testCaseService.getDetails(id, version).toDto();
    }

    @Operation(summary="Update a test case")
    @Parameters(value={@Parameter(name="id", description="The test case ID")})
    @PutMapping(value={"/{id}"})
    public TestCaseDto update(@PathVariable Long id, @RequestBody TestCaseDto testCaseDto) {
        TestCase updateTestCase = (TestCase)this.testCaseService.update(id, (Entity)testCaseDto.toEntity());
        return updateTestCase.toDto(true);
    }

    @Operation(summary="Delete a test case", description="The deleted test case will be marked as deleted and not shown in the list of test cases. ")
    @Parameters(value={@Parameter(name="id", description="The test case ID")})
    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable Long id) {
        this.testCaseService.delete(id);
    }

    @Operation(summary="Search test cases")
    @Parameters(value={@Parameter(name="filter", description="Test case search filter")})
    @PostMapping(value={"/search"})
    public DtoQueryResult<Dto> search(@RequestBody TestCaseFilter filter) {
        EntityQueryResult queryResult = this.testCaseService.search((Filter)filter);
        return queryResult.toDto();
    }

    @Operation(summary="Copy a test case", description="Copy the specified test case with all properties and details")
    @Parameters(value={@Parameter(name="id", description="The ID of test case to be copied")})
    @PostMapping(value={"/{id}/clone"})
    public TestCaseDto clone(@PathVariable Long id) {
        TestCase clonedCase = this.testCaseService.clone(id.longValue());
        return clonedCase.toDto(true);
    }
}

