/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.testing.controller;

import com.shimi.gogoscrum.common.controller.BaseController;
import com.shimi.gogoscrum.testing.dto.TestPlanDto;
import com.shimi.gogoscrum.testing.model.TestPlan;
import com.shimi.gogoscrum.testing.model.TestPlanFilter;
import com.shimi.gogoscrum.testing.model.TestPlanItem;
import com.shimi.gogoscrum.testing.model.TestPlanItemFilter;
import com.shimi.gogoscrum.testing.service.TestPlanItemService;
import com.shimi.gogoscrum.testing.service.TestPlanService;
import com.shimi.gsf.core.dto.Dto;
import com.shimi.gsf.core.dto.DtoQueryResult;
import com.shimi.gsf.core.exception.BadRequestException;
import com.shimi.gsf.core.model.Entity;
import com.shimi.gsf.core.model.EntityQueryResult;
import com.shimi.gsf.core.model.Filter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/testing/plans"})
@CrossOrigin
@Tag(name="Test plan", description="Test plan Management")
@RolesAllowed(value={"ROLE_USER"})
public class TestPlanController
extends BaseController {
    @Autowired
    private TestPlanService testPlanService;
    @Autowired
    private TestPlanItemService testPlanItemService;

    @Operation(summary="Create a test plan")
    @PostMapping
    public TestPlanDto create(@RequestBody TestPlanDto testPlanDto) {
        TestPlan testPlan = testPlanDto.toEntity();
        TestPlan savedTestPlan = (TestPlan)this.testPlanService.create((Entity)testPlan);
        return savedTestPlan.toDto();
    }

    @Operation(summary="Get test plan")
    @Parameters(value={@Parameter(name="id", description="The test plan ID")})
    @GetMapping(value={"/{id}"})
    public TestPlanDto get(@PathVariable Long id) {
        return ((TestPlan)this.testPlanService.get(id)).toDto(true);
    }

    @Operation(summary="Update a test plan")
    @Parameters(value={@Parameter(name="id", description="The test plan ID")})
    @PutMapping(value={"/{id}"})
    public TestPlanDto update(@PathVariable Long id, @RequestBody TestPlanDto testPlanDto) {
        TestPlan updateTestPlan = (TestPlan)this.testPlanService.update(id, (Entity)testPlanDto.toEntity());
        return updateTestPlan.toDto();
    }

    @Operation(summary="Delete a test plan", description="The deleted test plan will be marked as deleted and not shown in the list of test plans. ")
    @Parameters(value={@Parameter(name="id", description="The test plan ID")})
    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable Long id) {
        this.testPlanService.delete(id);
    }

    @Operation(summary="Clone a test plan", description="Create a copy of the specified test plan, including the links to test cases.")
    @Parameters(value={@Parameter(name="id", description="The test plan ID to clone")})
    @PostMapping(value={"/{id}/clone"})
    public TestPlanDto clone(@PathVariable Long id) {
        TestPlan clonedTestPlan = this.testPlanService.clone(id.longValue());
        return clonedTestPlan.toDto();
    }

    @Operation(summary="Search test plans")
    @Parameters(value={@Parameter(name="filter", description="Test plan search filter")})
    @PostMapping(value={"/search"})
    public DtoQueryResult<Dto> search(@RequestBody TestPlanFilter filter) {
        EntityQueryResult queryResult = this.testPlanService.search((Filter)filter);
        return queryResult.toDto();
    }

    @Operation(summary="Get test case IDs by test plan ID")
    @Parameters(value={@Parameter(name="testPlanId", description="The test plan ID")})
    @GetMapping(value={"/{testPlanId}/cases"})
    public List<Long> getTestCaseIds(@PathVariable Long testPlanId) {
        return this.testPlanItemService.findTestCaseIds(testPlanId);
    }

    @Operation(summary="Link test cases to a test plan")
    @Parameters(value={@Parameter(name="testPlanId", description="The test plan ID"), @Parameter(name="caseIds", description="List of test case IDs to link")})
    @PostMapping(value={"/{testPlanId}/cases"})
    public void linkAll(@PathVariable Long testPlanId, @RequestBody List<Long> caseIds) {
        this.testPlanItemService.linkAll(testPlanId, caseIds);
    }

    @Operation(summary="Search test plan items")
    @Parameters(value={@Parameter(name="filter", description="Test plan item search filter")})
    @PostMapping(value={"/{testPlanId}/cases/search"})
    public DtoQueryResult<Dto> searchPlanItems(@PathVariable Long testPlanId, @RequestBody TestPlanItemFilter filter) {
        filter.setTestPlanId(testPlanId);
        EntityQueryResult queryResult = this.testPlanItemService.search((Filter)filter);
        return queryResult.toDto();
    }

    @Operation(summary="Delete a test plan item by ID")
    @Parameters(value={@Parameter(name="testPlanId", description="The test plan ID"), @Parameter(name="itemId", description="The test plan item ID")})
    @DeleteMapping(value={"/{testPlanId}/cases/{itemId}"})
    public void deletePlanItem(@PathVariable Long testPlanId, @PathVariable Long itemId) {
        TestPlanItem item = (TestPlanItem)this.testPlanItemService.get(itemId);
        if (!item.getTestPlanId().equals(testPlanId)) {
            throw new BadRequestException("Test plan item does not belong to the specified test plan.");
        }
        this.testPlanItemService.delete(itemId);
    }
}

