/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.testing.controller;

import com.shimi.gogoscrum.common.controller.BaseController;
import com.shimi.gogoscrum.testing.dto.TestReportDto;
import com.shimi.gogoscrum.testing.model.TestReport;
import com.shimi.gogoscrum.testing.model.TestReportFilter;
import com.shimi.gogoscrum.testing.service.TestReportService;
import com.shimi.gsf.core.dto.Dto;
import com.shimi.gsf.core.dto.DtoQueryResult;
import com.shimi.gsf.core.model.Entity;
import com.shimi.gsf.core.model.EntityQueryResult;
import com.shimi.gsf.core.model.Filter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/testing/reports"})
@CrossOrigin
@Tag(name="Test report", description="Test report Management")
@RolesAllowed(value={"ROLE_USER"})
public class TestReportController
extends BaseController {
    @Autowired
    private TestReportService testReportService;

    @Operation(summary="Generate test report for preview", description="The generate report is not persisted at this moment")
    @Parameters(value={@Parameter(name="testPlanId", description="The test plan ID")})
    @GetMapping(value={"/preview/{testPlanId}"})
    public TestReportDto preview(@PathVariable Long testPlanId) {
        return this.testReportService.generateReport(testPlanId).toDto();
    }

    @Operation(summary="Create a test report")
    @PostMapping
    public TestReportDto create(@RequestBody TestReportDto testReportDto) {
        TestReport testReport = testReportDto.toEntity();
        TestReport savedTestReport = (TestReport)this.testReportService.create((Entity)testReport);
        return savedTestReport.toDto();
    }

    @Operation(summary="Get test report")
    @Parameters(value={@Parameter(name="id", description="The test report ID")})
    @GetMapping(value={"/{id}"})
    public TestReportDto get(@PathVariable Long id) {
        return ((TestReport)this.testReportService.get(id)).toDto(true);
    }

    @Operation(summary="Update a test report")
    @Parameters(value={@Parameter(name="id", description="The test report ID")})
    @PutMapping(value={"/{id}"})
    public TestReportDto update(@PathVariable Long id, @RequestBody TestReportDto testReportDto) {
        TestReport updateTestReport = (TestReport)this.testReportService.update(id, (Entity)testReportDto.toEntity());
        return updateTestReport.toDto();
    }

    @Operation(summary="Delete a test report", description="Delete a test report by ID")
    @Parameters(value={@Parameter(name="id", description="The test report ID")})
    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable Long id) {
        this.testReportService.delete(id);
    }

    @Operation(summary="Search test reports")
    @Parameters(value={@Parameter(name="filter", description="Test report search filter")})
    @PostMapping(value={"/search"})
    public DtoQueryResult<Dto> search(@RequestBody TestReportFilter filter) {
        EntityQueryResult queryResult = this.testReportService.search((Filter)filter);
        return queryResult.toDto();
    }
}

