/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.testing.controller;

import com.shimi.gogoscrum.common.controller.BaseController;
import com.shimi.gogoscrum.testing.dto.TestRunDto;
import com.shimi.gogoscrum.testing.model.TestRun;
import com.shimi.gogoscrum.testing.model.TestRunFilter;
import com.shimi.gogoscrum.testing.service.TestRunService;
import com.shimi.gsf.core.dto.Dto;
import com.shimi.gsf.core.dto.DtoQueryResult;
import com.shimi.gsf.core.model.Entity;
import com.shimi.gsf.core.model.EntityQueryResult;
import com.shimi.gsf.core.model.Filter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/testing/runs"})
@CrossOrigin
@Tag(name="Test run", description="Test run Management")
@RolesAllowed(value={"ROLE_USER"})
public class TestRunController
extends BaseController {
    @Autowired
    private TestRunService testRunService;

    @Operation(summary="Create a test run")
    @PostMapping
    public TestRunDto create(@RequestBody TestRunDto testRunDto) {
        TestRun testRun = testRunDto.toEntity();
        TestRun savedTestRun = (TestRun)this.testRunService.create((Entity)testRun);
        return savedTestRun.toDto(true);
    }

    @Operation(summary="Get test run")
    @Parameters(value={@Parameter(name="id", description="The test run ID")})
    @GetMapping(value={"/{id}"})
    public TestRunDto get(@PathVariable Long id) {
        return ((TestRun)this.testRunService.get(id)).toDto(true);
    }

    @Operation(summary="Update a test run")
    @Parameters(value={@Parameter(name="id", description="The test run ID")})
    @PutMapping(value={"/{id}"})
    public TestRunDto update(@PathVariable Long id, @RequestBody TestRunDto testRunDto) {
        TestRun updateTestRun = (TestRun)this.testRunService.update(id, (Entity)testRunDto.toEntity());
        return updateTestRun.toDto(true);
    }

    @Operation(summary="Delete a test run", description="The deleted test run will be marked as deleted and not shown in the list of test runs. ")
    @Parameters(value={@Parameter(name="id", description="The test run ID")})
    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable Long id) {
        this.testRunService.delete(id);
    }

    @Operation(summary="Search test runs")
    @Parameters(value={@Parameter(name="filter", description="Test run search filter")})
    @PostMapping(value={"/search"})
    public DtoQueryResult<Dto> search(@RequestBody TestRunFilter filter) {
        EntityQueryResult queryResult = this.testRunService.search((Filter)filter);
        return queryResult.toDto();
    }
}

