/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.testing.dto;

import com.shimi.gogoscrum.common.dto.BaseDto;
import com.shimi.gogoscrum.testing.model.TestPlan;
import com.shimi.gogoscrum.testing.model.TestType;
import com.shimi.gogoscrum.user.dto.UserDto;
import java.util.Date;
import org.springframework.beans.BeanUtils;

public class TestPlanDto
extends BaseDto {
    private static final long serialVersionUID = -9112235291686840738L;
    private Long projectId;
    private String name;
    private Date startDate;
    private Date endDate;
    private TestType type;
    private UserDto owner;
    private Long caseCount = 0L;
    private Long executedCount = 0L;
    private Long failedCount = 0L;
    private Long successCount = 0L;
    private Long blockedCount = 0L;
    private Long skippedCount = 0L;

    public TestPlan toEntity() {
        TestPlan entity = new TestPlan();
        BeanUtils.copyProperties((Object)this, (Object)entity);
        if (this.owner != null) {
            entity.setOwner(this.owner.toEntity());
        }
        return entity;
    }

    public TestPlanDto() {
    }

    public TestPlanDto(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public TestType getType() {
        return this.type;
    }

    public void setType(TestType type) {
        this.type = type;
    }

    public UserDto getOwner() {
        return this.owner;
    }

    public void setOwner(UserDto owner) {
        this.owner = owner;
    }

    public Long getCaseCount() {
        return this.caseCount;
    }

    public void setCaseCount(Long caseCount) {
        this.caseCount = caseCount;
    }

    public Long getExecutedCount() {
        return this.executedCount;
    }

    public void setExecutedCount(Long executedCount) {
        this.executedCount = executedCount;
    }

    public Long getFailedCount() {
        return this.failedCount;
    }

    public void setFailedCount(Long failedCount) {
        this.failedCount = failedCount;
    }

    public Long getSuccessCount() {
        return this.successCount;
    }

    public void setSuccessCount(Long successCount) {
        this.successCount = successCount;
    }

    public Long getBlockedCount() {
        return this.blockedCount;
    }

    public void setBlockedCount(Long blockedCount) {
        this.blockedCount = blockedCount;
    }

    public Long getSkippedCount() {
        return this.skippedCount;
    }

    public void setSkippedCount(Long skippedCount) {
        this.skippedCount = skippedCount;
    }

    public int getProgress() {
        long executed;
        long total = this.caseCount != null ? this.caseCount : 0L;
        long l = executed = this.executedCount != null ? this.executedCount : 0L;
        if (total == 0L) {
            return 0;
        }
        return Math.round((float)executed / (float)total * 100.0f);
    }

    public TestPlanDto normalize() {
        TestPlanDto normalized = new TestPlanDto();
        normalized.setId(this.id);
        normalized.setName(this.name);
        return normalized;
    }
}

