/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.testing.model;

import com.shimi.gogoscrum.common.model.BaseEntity;
import com.shimi.gogoscrum.file.model.File;
import com.shimi.gogoscrum.testing.dto.TestCaseDto;
import com.shimi.gogoscrum.testing.model.TestCaseDetails;
import com.shimi.gogoscrum.testing.model.TestRun;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToOne;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

@Entity
public class TestCase
extends BaseEntity {
    private static final long serialVersionUID = 1794849626692644392L;
    private Long projectId;
    private Long code;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="latest_details_id")
    private TestCaseDetails details;
    private boolean deleted = false;
    private Integer latestVersion;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="test_case_file", joinColumns={@JoinColumn(name="test_case_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="file_id", referencedColumnName="id")})
    private List<File> files = new ArrayList();
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="latest_run_id")
    private TestRun latestRun;

    public TestCaseDto toDto() {
        return this.toDto(false);
    }

    public TestCaseDto toDto(boolean detailed) {
        TestCaseDto dto = new TestCaseDto();
        BeanUtils.copyProperties((Object)this, (Object)dto);
        if (this.details != null) {
            dto.setDetails(this.details.toDto());
        }
        if (this.latestRun != null) {
            this.latestRun.setTestCase(null);
            dto.setLatestRun(this.latestRun.toDto());
        }
        if (this.createdBy != null) {
            dto.setCreatedBy(this.createdBy.toDto());
        }
        if (detailed && !CollectionUtils.isEmpty((Collection)this.files)) {
            List fileDtos = this.files.stream().map(File::toDto).collect(Collectors.toList());
            dto.setFiles(fileDtos);
        }
        return dto;
    }

    public TestCase() {
    }

    public TestCase(Long id) {
        this.id = id;
    }

    public Long getCode() {
        return this.code;
    }

    public void setCode(Long code) {
        this.code = code;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public TestCaseDetails getDetails() {
        return this.details;
    }

    public void setDetails(TestCaseDetails details) {
        this.details = details;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public Integer getLatestVersion() {
        return this.latestVersion;
    }

    public void setLatestVersion(Integer latestVersion) {
        this.latestVersion = latestVersion;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public TestRun getLatestRun() {
        return this.latestRun;
    }

    public void setLatestRun(TestRun latestRun) {
        this.latestRun = latestRun;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof TestCase)) {
            return false;
        }
        TestCase testCase = (TestCase)object;
        return this.deleted == testCase.deleted && this.projectId.equals(testCase.projectId) && Objects.equals(this.code, testCase.code) && this.details.equals((Object)testCase.details);
    }

    public int hashCode() {
        int result = this.projectId.hashCode();
        result = 31 * result + Objects.hashCode(this.code);
        result = 31 * result + this.details.hashCode();
        result = 31 * result + Boolean.hashCode(this.deleted);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TestCase{");
        sb.append("id=").append(this.id);
        sb.append(", code=").append(this.code);
        sb.append(", projectId=").append(this.projectId);
        sb.append('}');
        return sb.toString();
    }
}

