/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.testing.model;

import com.shimi.gogoscrum.common.model.BaseEntity;
import com.shimi.gogoscrum.common.model.Priority;
import com.shimi.gogoscrum.testing.dto.TestCaseDetailsDto;
import com.shimi.gogoscrum.testing.model.TestStep;
import com.shimi.gogoscrum.testing.model.TestType;
import com.shimi.gogoscrum.testing.utils.ListOfStepToStringConverter;
import com.shimi.gogoscrum.user.model.User;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.springframework.beans.BeanUtils;

@Entity
public class TestCaseDetails
extends BaseEntity {
    private static final long serialVersionUID = 7913042228963433520L;
    private Long testCaseId;
    private Long componentId;
    private String name;
    private String description;
    @Enumerated(value=EnumType.STRING)
    private TestType type;
    @Enumerated(value=EnumType.STRING)
    private Priority priority = Priority.NORMAL;
    private String preconditions;
    @Convert(converter=ListOfStepToStringConverter.class)
    private List<TestStep> steps = new ArrayList();
    private Integer version;
    @ManyToOne
    @JoinColumn(name="owner_id")
    @NotFound(action=NotFoundAction.IGNORE)
    private User owner;
    private Boolean automated = Boolean.FALSE;

    public TestCaseDetailsDto toDto() {
        TestCaseDetailsDto dto = new TestCaseDetailsDto();
        BeanUtils.copyProperties((Object)this, (Object)dto);
        if (this.owner != null) {
            dto.setOwner(this.owner.toDto().normalize());
        }
        return dto;
    }

    public TestCaseDetails() {
    }

    public TestCaseDetails(Long id) {
        this.id = id;
    }

    public String getPreconditions() {
        return this.preconditions;
    }

    public void setPreconditions(String preconditions) {
        this.preconditions = preconditions;
    }

    public List<TestStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<TestStep> steps) {
        this.steps = steps;
    }

    public Long getTestCaseId() {
        return this.testCaseId;
    }

    public void setTestCaseId(Long testCaseId) {
        this.testCaseId = testCaseId;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Long getComponentId() {
        return this.componentId;
    }

    public void setComponentId(Long componentId) {
        this.componentId = componentId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TestType getType() {
        return this.type;
    }

    public void setType(TestType type) {
        this.type = type;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User owner) {
        this.owner = owner;
    }

    public Boolean getAutomated() {
        return this.automated;
    }

    public void setAutomated(Boolean automated) {
        this.automated = automated;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof TestCaseDetails)) {
            return false;
        }
        TestCaseDetails that = (TestCaseDetails)object;
        return this.testCaseId.equals(that.testCaseId) && Objects.equals(this.componentId, that.componentId) && this.name.equals(that.name) && this.type == that.type && this.priority == that.priority && Objects.equals(this.preconditions, that.preconditions) && Objects.equals(this.steps, that.steps) && Objects.equals(this.version, that.version) && Objects.equals(this.description, that.description) && Objects.equals(this.owner, that.owner) && Objects.equals(this.automated, that.automated);
    }

    public int hashCode() {
        int result = this.testCaseId.hashCode();
        result = 31 * result + Objects.hashCode(this.componentId);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Objects.hashCode(this.type);
        result = 31 * result + this.priority.hashCode();
        result = 31 * result + Objects.hashCode(this.preconditions);
        result = 31 * result + Objects.hashCode(this.steps);
        result = 31 * result + Objects.hashCode(this.version);
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.owner);
        result = 31 * result + Objects.hashCode(this.automated);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TestCaseDetails{");
        sb.append("id=").append(this.id);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", testCaseId=").append(this.testCaseId);
        sb.append(", type=").append(this.type);
        sb.append(", priority=").append(this.priority);
        sb.append(", preconditions='").append(this.preconditions).append('\'');
        sb.append(", steps=").append(this.steps);
        sb.append(", version=").append(this.version);
        sb.append(", componentId=").append(this.componentId);
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", owner=").append(this.owner);
        sb.append(", automated=").append(this.automated);
        sb.append('}');
        return sb.toString();
    }
}

