/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.testing.model;

import com.shimi.gogoscrum.common.model.BaseEntity;
import com.shimi.gogoscrum.testing.dto.TestPlanDto;
import com.shimi.gogoscrum.testing.model.TestType;
import com.shimi.gogoscrum.user.model.User;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.util.Date;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.springframework.beans.BeanUtils;

@Entity
public class TestPlan
extends BaseEntity {
    private static final long serialVersionUID = -6161570762726533308L;
    private Long projectId;
    private String name;
    private Date startDate;
    private Date endDate;
    @Enumerated(value=EnumType.STRING)
    private TestType type;
    @ManyToOne
    @JoinColumn(name="owner_id")
    @NotFound(action=NotFoundAction.IGNORE)
    private User owner;
    private Long caseCount = 0L;
    private Long executedCount = 0L;
    private Long failedCount = 0L;
    private Long successCount = 0L;
    private Long blockedCount = 0L;
    private Long skippedCount = 0L;
    private boolean deleted = false;

    public TestPlanDto toDto() {
        return this.toDto(false);
    }

    public TestPlanDto toDto(boolean detailed) {
        TestPlanDto dto = new TestPlanDto();
        BeanUtils.copyProperties((Object)this, (Object)dto);
        if (this.createdBy != null) {
            dto.setCreatedBy(this.createdBy.toDto());
        }
        if (this.owner != null) {
            dto.setOwner(this.owner.toDto().normalize());
        }
        return dto;
    }

    public TestPlan() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TestPlan(Long id) {
        this.id = id;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public TestType getType() {
        return this.type;
    }

    public void setType(TestType type) {
        this.type = type;
    }

    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User owner) {
        this.owner = owner;
    }

    public Long getCaseCount() {
        return this.caseCount;
    }

    public void setCaseCount(Long caseCount) {
        this.caseCount = caseCount;
    }

    public Long getExecutedCount() {
        return this.executedCount;
    }

    public void setExecutedCount(Long executedCount) {
        this.executedCount = executedCount;
    }

    public Long getSkippedCount() {
        return this.skippedCount;
    }

    public void setSkippedCount(Long skippedCount) {
        this.skippedCount = skippedCount;
    }

    public Long getFailedCount() {
        return this.failedCount;
    }

    public void setFailedCount(Long failedCount) {
        this.failedCount = failedCount;
    }

    public Long getBlockedCount() {
        return this.blockedCount;
    }

    public void setBlockedCount(Long blockedCount) {
        this.blockedCount = blockedCount;
    }

    public Long getSuccessCount() {
        return this.successCount;
    }

    public void setSuccessCount(Long successCount) {
        this.successCount = successCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TestPlan{");
        sb.append("projectId=").append(this.projectId);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", caseCount=").append(this.caseCount);
        sb.append(", executedCount=").append(this.executedCount);
        sb.append(", failedCount=").append(this.failedCount);
        sb.append(", successCount=").append(this.successCount);
        sb.append(", blockedCount=").append(this.blockedCount);
        sb.append(", skippedCount=").append(this.skippedCount);
        sb.append(", deleted=").append(this.deleted);
        sb.append(", id=").append(this.id);
        sb.append('}');
        return sb.toString();
    }
}

